/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.types;

import cc.mallet.grmm.inference.Utils;
import cc.mallet.grmm.types.AbstractFactor;
import cc.mallet.grmm.types.AbstractTableFactor;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.HashVarSet;
import cc.mallet.grmm.types.TableFactor;
import cc.mallet.grmm.types.UnmodifiableVarSet;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.grmm.types.Variable;
import cc.mallet.types.Matrix;
import cc.mallet.types.Matrixn;
import cc.mallet.types.SparseMatrixn;
import cc.mallet.util.Randoms;
import gnu.trove.TObjectIntHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Assignment
extends AbstractFactor
implements Serializable {
    transient TObjectIntHashMap var2idx;
    transient ArrayList values;
    double scale = 1.0;
    private static final long serialVersionUID = 1L;
    private static final int SERIAL_VERSION = 2;

    public Assignment() {
        super(new HashVarSet());
        this.var2idx = new TObjectIntHashMap();
        this.values = new ArrayList();
    }

    public Assignment(Variable var, int outcome) {
        this();
        this.addRow(new Variable[]{var}, new int[]{outcome});
    }

    public Assignment(Variable var, double outcome) {
        this();
        this.addRow(new Variable[]{var}, new double[]{outcome});
    }

    public Assignment(Variable[] vars, int[] outcomes) {
        this.var2idx = new TObjectIntHashMap(vars.length);
        this.values = new ArrayList();
        this.addRow(vars, outcomes);
    }

    public Assignment(Variable[] vars, double[] outcomes) {
        this.var2idx = new TObjectIntHashMap(vars.length);
        this.values = new ArrayList();
        this.addRow(vars, outcomes);
    }

    public Assignment(List vars, int[] outcomes) {
        this.var2idx = new TObjectIntHashMap(vars.size());
        this.values = new ArrayList();
        this.addRow(vars.toArray(new Variable[0]), outcomes);
    }

    public Assignment(FactorGraph mdl, int[] outcomes) {
        this.var2idx = new TObjectIntHashMap(mdl.numVariables());
        this.values = new ArrayList();
        Variable[] vars = new Variable[mdl.numVariables()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = mdl.get(i);
        }
        this.addRow(vars, outcomes);
    }

    public static Assignment union(Assignment assn1, Assignment assn2) {
        Assignment ret = new Assignment();
        HashVarSet vars = new HashVarSet();
        vars.addAll(assn1.vars);
        vars.addAll(assn2.vars);
        Variable[] varr = vars.toVariableArray();
        if (assn1.numRows() == 0) {
            return (Assignment)assn2.duplicate();
        }
        if (assn2.numRows() == 0) {
            return (Assignment)assn1.duplicate();
        }
        if (assn1.numRows() != assn2.numRows()) {
            throw new IllegalArgumentException("Number of rows not equal.");
        }
        for (int ri = 0; ri < assn2.numRows(); ++ri) {
            Object[] row = new Object[vars.size()];
            for (int vi = 0; vi < vars.size(); ++vi) {
                Object val2;
                Variable var = varr[vi];
                if (!assn1.containsVar(var)) {
                    row[vi] = assn2.getObject(var);
                    continue;
                }
                if (!assn2.containsVar(var)) {
                    row[vi] = assn1.getObject(var);
                    continue;
                }
                Object val1 = assn1.getObject(var);
                if (!val1.equals(val2 = assn2.getObject(var))) {
                    throw new IllegalArgumentException("Assignments don't match on intersection.\n  ASSN1[" + var + "] = " + val1 + "\n  ASSN2[" + var + "] = " + val2);
                }
                row[vi] = val1;
            }
            ret.addRow(varr, row);
        }
        return ret;
    }

    public static Assignment restriction(Assignment assn, VarSet varSet) {
        return (Assignment)assn.marginalize(varSet);
    }

    public Assignment getRow(int ridx) {
        Assignment assn = new Assignment();
        assn.var2idx = this.var2idx.clone();
        assn.vars = new UnmodifiableVarSet(this.vars);
        assn.addRow((Object[])this.values.get(ridx));
        return assn;
    }

    public void addRow(Variable[] vars, int[] values) {
        this.addRow(vars, this.boxArray(values));
    }

    public void addRow(Variable[] vars, double[] values) {
        this.addRow(vars, this.boxArray(values));
    }

    public void addRow(Variable[] vars, Object[] values) {
        this.checkAssignmentsMatch(vars);
        this.addRow(values);
    }

    public void addRow(Object[] row) {
        if (row.length != this.numVariables()) {
            throw new IllegalArgumentException("Wrong number of variables when adding to " + this + "\nwas:\n");
        }
        this.values.add(row);
    }

    public void addRow(Assignment other) {
        this.checkAssignmentsMatch(other);
        for (int ridx = 0; ridx < other.numRows(); ++ridx) {
            Object[] otherRow = (Object[])other.values.get(ridx);
            Object[] row = new Object[otherRow.length];
            for (int vi = 0; vi < row.length; ++vi) {
                Variable var = this.getVariable(vi);
                row[vi] = other.getObject(ridx, var);
            }
            this.addRow(row);
        }
    }

    private void checkAssignmentsMatch(Assignment other) {
        if (this.numVariables() == 0) {
            this.setVariables(other.vars.toVariableArray());
        } else {
            if (this.numVariables() != other.numVariables()) {
                throw new IllegalArgumentException("Attempt to add row with non-matching variables.\n  This has vars: " + this.varSet() + "\n  Other has vars:" + other.varSet());
            }
            for (int vi = 0; vi < this.numVariables(); ++vi) {
                Variable var = this.getVariable(vi);
                if (other.containsVar(var)) continue;
                throw new IllegalArgumentException("Attempt to add row with non-matching variables");
            }
        }
    }

    private void checkAssignmentsMatch(Variable[] vars) {
        if (this.numRows() == 0) {
            this.setVariables(vars);
        } else {
            this.checkVariables(vars);
        }
    }

    private void checkVariables(Variable[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            Variable v1 = vars[i];
            Variable v2 = this.vars.get(i);
            if (v1 == v2) continue;
            throw new IllegalArgumentException("Attempt to add row with incompatible variables.");
        }
    }

    private void setVariables(Variable[] varr) {
        this.vars.addAll(Arrays.asList(varr));
        for (int i = 0; i < varr.length; ++i) {
            Variable v = varr[i];
            this.var2idx.put((Object)v, i);
        }
    }

    private Object[] boxArray(int[] values) {
        Object[] ret = new Object[values.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Integer(values[i]);
        }
        return ret;
    }

    private Object[] boxArray(double[] values) {
        Object[] ret = new Object[values.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new Double(values[i]);
        }
        return ret;
    }

    public int numRows() {
        return this.values.size();
    }

    public int get(Variable var) {
        if (this.numRows() != 1) {
            throw new IllegalArgumentException("Attempt to call get() with no row specified: " + this);
        }
        return this.get(0, var);
    }

    public double getDouble(Variable var) {
        if (this.numRows() != 1) {
            throw new IllegalArgumentException("Attempt to call getDouble() with no row specified: " + this);
        }
        return this.getDouble(0, var);
    }

    public Object getObject(Variable var) {
        if (this.numRows() != 1) {
            throw new IllegalArgumentException("Attempt to call getObject() with no row specified: " + this);
        }
        return this.getObject(0, var);
    }

    public int get(int ridx, Variable var) {
        int idx = this.colOfVar(var, false);
        if (idx == -1) {
            throw new IndexOutOfBoundsException("Assignment does not give a value for variable " + var);
        }
        Object[] row = (Object[])this.values.get(ridx);
        Integer integer = (Integer)row[idx];
        return integer;
    }

    public double getDouble(int ridx, Variable var) {
        int idx = this.colOfVar(var, false);
        if (idx == -1) {
            throw new IndexOutOfBoundsException("Assignment does not give a value for variable " + var);
        }
        Object[] row = (Object[])this.values.get(ridx);
        Double dbl = (Double)row[idx];
        return dbl;
    }

    public Object getObject(int ri, Variable var) {
        Object[] row = (Object[])this.values.get(ri);
        int ci = this.colOfVar(var, false);
        if (ci < 0) {
            throw new IllegalArgumentException("Variable " + var + " does not exist in this assignment.");
        }
        return row[ci];
    }

    @Override
    public Variable getVariable(int i) {
        return this.vars.get(i);
    }

    public Variable[] getVars() {
        return this.vars.toArray(new Variable[0]);
    }

    public int size() {
        return this.numVariables();
    }

    public static Assignment makeFromSingleIndex(VarSet clique, int idx) {
        int N = clique.size();
        Variable[] vars = clique.toVariableArray();
        int[] idxs = new int[N];
        int[] szs = new int[N];
        for (int i = 0; i < N; ++i) {
            Variable var = vars[i];
            szs[i] = var.getNumOutcomes();
        }
        Matrixn.singleToIndices(idx, idxs, szs);
        return new Assignment(vars, idxs);
    }

    public int singleIndex() {
        int nr = this.numRows();
        if (nr == 0) {
            return -1;
        }
        if (nr > 1) {
            throw new IllegalArgumentException("No row specified.");
        }
        return this.singleIndex(0);
    }

    private void checkIsSingleRow() {
        if (this.numRows() != 1) {
            throw new IllegalArgumentException("No row specified.");
        }
    }

    public int singleIndex(int row) {
        int[] szs = new int[this.numVariables()];
        for (int i = 0; i < this.numVariables(); ++i) {
            Variable var = this.vars.get(i);
            szs[i] = var.getNumOutcomes();
        }
        int[] idxs = this.toIntArray(row);
        return Matrixn.singleIndex(szs, idxs);
    }

    public int numVariables() {
        return this.vars.size();
    }

    private int[] toIntArray(int ridx) {
        int[] idxs = new int[this.numVariables()];
        Object[] row = (Object[])this.values.get(ridx);
        for (int i = 0; i < row.length; ++i) {
            Integer val = (Integer)row[i];
            idxs[i] = val;
        }
        return idxs;
    }

    public double[] toDoubleArray(int ridx) {
        double[] idxs = new double[this.numVariables()];
        Object[] row = (Object[])this.values.get(ridx);
        for (int i = 0; i < row.length; ++i) {
            Double val = (Double)row[i];
            idxs[i] = val;
        }
        return idxs;
    }

    @Override
    public Factor duplicate() {
        Assignment ret = new Assignment();
        ret.vars = new HashVarSet(this.vars);
        ret.var2idx = this.var2idx.clone();
        ret.values = new ArrayList(this.values.size());
        for (int ri = 0; ri < this.values.size(); ++ri) {
            Object[] vals = (Object[])this.values.get(ri);
            ret.values.add(vals.clone());
        }
        ret.scale = this.scale;
        return ret;
    }

    public void dump() {
        this.dump(new PrintWriter((Writer)new OutputStreamWriter(System.out), true));
    }

    public void dump(PrintWriter out) {
        out.print("ASSIGNMENT ");
        out.println(this.varSet());
        for (int vi = 0; vi < this.var2idx.size(); ++vi) {
            Variable var = this.vars.get(vi);
            out.print(var);
            out.print(" ");
        }
        out.println();
        for (int ri = 0; ri < this.numRows(); ++ri) {
            for (int vi = 0; vi < this.var2idx.size(); ++vi) {
                Variable var = this.vars.get(vi);
                Object obj = this.getObject(ri, var);
                out.print(obj);
                out.print(" ");
            }
            out.println();
        }
    }

    public void dumpNumeric() {
        for (int i = 0; i < this.var2idx.size(); ++i) {
            Variable var = this.vars.get(i);
            int outcome = this.get(var);
            System.out.println(var + " " + outcome);
        }
    }

    @Override
    public boolean containsVar(Variable var) {
        int idx = this.colOfVar(var, false);
        return idx != -1;
    }

    public void setValue(Variable var, int value) {
        this.checkIsSingleRow();
        this.setValue(0, var, value);
    }

    public void setValue(int ridx, Variable var, int value) {
        int ci = this.colOfVar(var, true);
        Object[] row = (Object[])this.values.get(ridx);
        row[ci] = new Integer(value);
    }

    public void setDouble(int ridx, Variable var, double value) {
        int ci = this.colOfVar(var, true);
        Object[] row = (Object[])this.values.get(ridx);
        row[ci] = new Double(value);
    }

    private int colOfVar(Variable var, boolean doAdd) {
        if (this.var2idx.containsKey((Object)var)) {
            return this.var2idx.get((Object)var);
        }
        if (doAdd) {
            return this.addVar(var);
        }
        return -1;
    }

    private int addVar(Variable var) {
        int ci = this.vars.size();
        this.vars.add(var);
        this.var2idx.put((Object)var, ci);
        for (int i = 0; i < this.numRows(); ++i) {
            Object[] oldVal = (Object[])this.values.get(i);
            Object[] newVal = new Object[ci + 1];
            System.arraycopy(oldVal, 0, newVal, 0, ci);
            this.values.set(i, newVal);
        }
        return ci;
    }

    public void setRow(int ridx, Assignment other) {
        this.checkAssignmentsMatch(other);
        Object[] row = (Object[])other.values.get(ridx);
        this.values.set(ridx, row.clone());
    }

    public void setRow(int ridx, int[] vals) {
        this.values.set(ridx, this.boxArray(vals));
    }

    @Override
    protected Factor extractMaxInternal(VarSet varSet) {
        return this.asTable().extractMax(varSet);
    }

    @Override
    protected double lookupValueInternal(int assnIdx) {
        int val = 0;
        for (int ri = 0; ri < this.numRows(); ++ri) {
            if (this.singleIndex(ri) != assnIdx) continue;
            ++val;
        }
        return (double)val * this.scale;
    }

    @Override
    protected Factor marginalizeInternal(VarSet varsToKeep) {
        Assignment ret = new Assignment();
        Variable[] vars = varsToKeep.toVariableArray();
        for (int ri = 0; ri < this.numRows(); ++ri) {
            Object[] row = new Object[vars.length];
            for (int vi = 0; vi < varsToKeep.size(); ++vi) {
                Variable var = varsToKeep.get(vi);
                row[vi] = this.getObject(ri, var);
            }
            ret.addRow(vars, row);
        }
        ret.scale = this.scale;
        return ret;
    }

    @Override
    public boolean almostEquals(Factor p, double epsilon) {
        return this.asTable().almostEquals(p, epsilon);
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public Factor normalize() {
        this.scale = 1.0 / (double)this.numRows();
        return this;
    }

    @Override
    public Assignment sample(Randoms r) {
        int ri = r.nextInt(this.numRows());
        Object[] vals = (Object[])this.values.get(ri);
        Assignment assn = new Assignment();
        Variable[] varr = this.vars.toArray(new Variable[this.numVariables()]);
        assn.addRow(varr, vals);
        return assn;
    }

    @Override
    public String dumpToString() {
        StringWriter writer = new StringWriter();
        this.dump(new PrintWriter(writer));
        return writer.toString();
    }

    @Override
    public Factor slice(Assignment assn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractTableFactor asTable() {
        Variable[] varr = this.vars.toArray(new Variable[0]);
        int[] idxs = new int[this.numRows()];
        double[] vals = new double[this.numRows()];
        int ri = 0;
        while (ri < this.numRows()) {
            idxs[ri] = this.singleIndex(ri);
            int n = ri++;
            vals[n] = vals[n] + 1.0;
        }
        SparseMatrixn matrix = new SparseMatrixn(Utils.toSizesArray(varr), idxs, vals);
        return new TableFactor(varr, (Matrix)matrix);
    }

    public List asList() {
        ArrayList<Assignment> lst = new ArrayList<Assignment>(this.numRows());
        for (int ri = 0; ri < this.numRows(); ++ri) {
            lst.add(this.getRow(ri));
        }
        return lst;
    }

    public Assignment subAssn(int start, int end) {
        Assignment other = new Assignment();
        for (int ri = start; ri < end; ++ri) {
            other.addRow(this.getRow(ri));
        }
        return other;
    }

    public int[] getColumnInt(Variable x1) {
        int[] ret = new int[this.numRows()];
        for (int ri = 0; ri < ret.length; ++ri) {
            ret[ri] = this.get(ri, x1);
        }
        return ret;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        int numVariables = in.readInt();
        this.var2idx = new TObjectIntHashMap(numVariables);
        for (int vi = 0; vi < numVariables; ++vi) {
            Variable var = (Variable)in.readObject();
            this.var2idx.put((Object)var, vi);
        }
        int numRows = in.readInt();
        this.values = new ArrayList(numRows);
        for (int ri = 0; ri < numRows; ++ri) {
            Object[] row = (Object[])in.readObject();
            this.values.add(row);
        }
        this.scale = version >= 2 ? in.readDouble() : 1.0;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(2);
        out.writeInt(this.numVariables());
        for (int vi = 0; vi < this.numVariables(); ++vi) {
            out.writeObject(this.getVariable(vi));
        }
        out.writeInt(this.numRows());
        for (int ri = 0; ri < this.numRows(); ++ri) {
            Object[] row = (Object[])this.values.get(ri);
            out.writeObject(row);
        }
        out.writeDouble(this.scale);
    }
}

