/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.grmm.inference;

import cc.mallet.grmm.inference.JunctionTree;
import cc.mallet.grmm.inference.JunctionTreeInferencer;
import cc.mallet.grmm.inference.Sampler;
import cc.mallet.grmm.types.Assignment;
import cc.mallet.grmm.types.Factor;
import cc.mallet.grmm.types.FactorGraph;
import cc.mallet.grmm.types.VarSet;
import cc.mallet.util.Randoms;

public class ExactSampler
implements Sampler {
    Randoms r;

    public ExactSampler() {
        this(new Randoms());
    }

    public ExactSampler(Randoms r) {
        this.r = r;
    }

    @Override
    public Assignment sample(FactorGraph mdl, int N) {
        JunctionTreeInferencer jti = new JunctionTreeInferencer();
        jti.computeMarginals(mdl);
        JunctionTree jt = jti.lookupJunctionTree();
        VarSet vs = mdl.varSet();
        Assignment assns = new Assignment();
        for (int i = 0; i < N; ++i) {
            Assignment assn = this.sampleOneAssn(jt);
            assns.addRow(vs.toVariableArray(), this.reorderCols(assn, vs));
        }
        return assns;
    }

    private Object[] reorderCols(Assignment assn, VarSet vs) {
        Object[] vals = new Object[vs.size()];
        for (int vi = 0; vi < vs.size(); ++vi) {
            vals[vi] = assn.getObject(vs.get(vi));
        }
        return vals;
    }

    private Assignment sampleOneAssn(JunctionTree jt) {
        VarSet root = (VarSet)jt.getRoot();
        return this.sampleAssignmentRec(jt, new Assignment(), root);
    }

    private Assignment sampleAssignmentRec(JunctionTree jt, Assignment assn, VarSet varSet) {
        Factor marg = jt.getCPF(varSet);
        Factor slice = marg.slice(assn);
        Assignment sampled = slice.sample(this.r);
        assn = Assignment.union(assn, sampled);
        for (VarSet child : jt.getChildren(varSet)) {
            Assignment other = this.sampleAssignmentRec(jt, assn, child);
            assn = Assignment.union(assn, other);
        }
        return assn;
    }

    @Override
    public void setRandom(Randoms r) {
        this.r = r;
    }
}

