# WARNING - Generated by {fusen} from dev/flat_utils.Rmd: do not edit by hand

# Processed data
processed_path <- system.file(
    "three_processed_spectra_with_one_peakless.RDS",
    package = "maldipickr")
processed <- readRDS(processed_path) %>% list()
test_that("remove_spectra works on processed spectra", {
  expect_mapequal(
    remove_spectra(processed, "empty_H12") %>% base::lengths(),
    c(spectra = 2L, peaks = 2L, metadata = 3L)
  )
})
test_that("remove_spectra fails with wrong input on processed spectra", {
  expect_error(
    remove_spectra(processed, "empty_H2") ,
    "Spectra names in 'to_remove'"
  )
  expect_error(
    remove_spectra(processed, c(TRUE, FALSE)) ,
    "remove_spectra\\(\\) with processed spectra expects spectra names"
  )
})
# Raw data
directory_biotyper_spectra <- system.file(
  "toy-species-spectra",
  package = "maldipickr"
)
spectra_list <- import_biotyper_spectra(directory_biotyper_spectra)[1:2]
spectra_list <- c(spectra_list, MALDIquant::createMassSpectrum(0, 0))
test_that("remove_spectra works on raw spectra", {
  expect_equal(
    remove_spectra(spectra_list, c(FALSE, FALSE, TRUE)) %>% base::lengths(),
    c(20882L, 20882L)
  )
  expect_equal(
    remove_spectra(spectra_list, check_spectra(spectra_list)) %>% base::lengths(),
    c(20882L, 20882L)
  )
})
test_that("remove_spectra fails with wrong input on raw spectra", {
  expect_error(
    remove_spectra(spectra_list, "species1"),
    "Non logical values in 'to_remove'"
  )
})
