# WARNING - Generated by {fusen} from dev/flat_utils.Rmd: do not edit by hand

#' Remove (raw or processed) spectra
#'
#' The `remove_spectra()` function is used to discard specific spectra from (1) raw spectra list by removing them, or (2) processed spectra by removing them from the spectra, peaks and metadata objects.
#'
#' @param spectra_list A list of [MALDIquant::MassSpectrum] objects OR A list of processed spectra from [process_spectra]
#' @param to_remove The spectra to be removed. In the case of raw spectra: a logical vector same size of `spectra_list` or from [check_spectra] function. In the case of processed spectra: names of the spectra as formatted in [get_spectra_names] in the `sanitized_name` column.
#'
#' @return The same object as `spectra_list` minus the spectra in `to_remove`.
#'
#' @export
#' @examples
#' # Get an example directory of six Bruker MALDI Biotyper spectra
#' directory_biotyper_spectra <- system.file(
#'   "toy-species-spectra",
#'   package = "maldipickr"
#' )
#' # Import only the first two spectra
#' spectra_list <- import_biotyper_spectra(directory_biotyper_spectra)[1:2]
#' # Introduce artificially an empty raw spectra
#' spectra_list <- c(spectra_list, MALDIquant::createMassSpectrum(0, 0))
#' # Empty spectra are detected by `check_spectra()`
#' #   and can be removed by `remove_spectra()`
#' spectra_list %>% 
#'   remove_spectra(to_remove = check_spectra(.))
#'
#' # Get an example processed spectra
#' processed_path <- system.file(
#'     "three_processed_spectra_with_one_peakless.RDS",
#'     package = "maldipickr")
#' processed <- readRDS(processed_path) %>% list()
#'
#' # Remove a specific spectra
#' remove_spectra(processed, "empty_H12")
remove_spectra <- function(spectra_list, to_remove) {
  if (base::class(spectra_list) == "list" &
    base::class(spectra_list[[1]]) == "MassSpectrum"
  ) {
    # spectra_list is a raw spectra
    # to_remove should be logical vector
    remove_spectra_logical(spectra_list, to_remove) %>%
      return()
  } else if (is_a_processed_spectra_list(spectra_list)) {
    if (base::class(to_remove) != "character") {
      stop(
        "remove_spectra() with processed spectra expects spectra names in 'to_remove'"
      )
    }
    spectra_names <- spectra_list[[1]][["metadata"]][["name"]]
    if (!to_remove %in% spectra_names) {
      stop(
        "Spectra names in 'to_remove' are not present in the spectra list"
      )
    }
    to_remove <- spectra_names %in% to_remove

    list(
      "spectra" = remove_spectra_logical(spectra_list[[1]][["spectra"]], to_remove),
      "peaks" = remove_spectra_logical(spectra_list[[1]][["peaks"]], to_remove),
      "metadata" = spectra_list[[1]][["metadata"]][!to_remove, ]
    ) %>% return()
  } else {
    stop("spectra_list is not a list of raw spectra nor a list of processed spectra")
  }
}
