% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment.R
\name{Segment}
\alias{Segment}
\title{Segment}
\description{
A Segment object is automatically constructed and attached to
the Pipeline when a call to \verb{make_*()} is made. It stores the relationships
between targets, dependencies, and sources.
}
\seealso{
Other segment: 
\code{\link{SegmentRecipe}},
\code{\link{SegmentSource}}
}
\concept{segment}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{targets}}{A character vector of paths to files}

\item{\code{dependencies}}{A character vector of paths to files which the \code{targets}
depend on}

\item{\code{packages}}{A character vector of names of packages which \code{targets}
depend on}

\item{\code{force}}{A logical determining whether or not execution of the \code{source}
or \code{recipe} will be forced (i.e. happen whether or not the targets are
out-of-date)}

\item{\code{envir}}{The environment in which to execute the instructions.}

\item{\code{result}}{An object, whatever is returned by executing the instructions}

\item{\code{executed}}{A logical, whether or not the instructions were executed}

\item{\code{execution_time}}{A difftime, the time taken to execute the instructions}

\item{\code{label}}{A short label for the segment}

\item{\code{note}}{A description of what the segment does}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{edges}}{Get edges connecting the dependencies, instructions, and targets}

\item{\code{nodes}}{Get nodes corresponding to  dependencies, instructions, and targets}

\item{\code{text_summary}}{A plain text summary of the Segment}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Segment-new}{\code{Segment$new()}}
\item \href{#method-Segment-print}{\code{Segment$print()}}
\item \href{#method-Segment-update_result}{\code{Segment$update_result()}}
\item \href{#method-Segment-annotate}{\code{Segment$annotate()}}
\item \href{#method-Segment-clone}{\code{Segment$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Segment-new"></a>}}
\if{latex}{\out{\hypertarget{method-Segment-new}{}}}
\subsection{Method \code{new()}}{
Initialise a new Segment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Segment$new(
  id,
  targets,
  dependencies,
  packages,
  envir,
  force,
  executed,
  result,
  execution_time
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{An integer that uniquely identifies the segment}

\item{\code{targets}}{A character vector of paths to files}

\item{\code{dependencies}}{A character vector of paths to files which the \code{targets}
depend on}

\item{\code{packages}}{A character vector of names of packages which \code{targets}
depend on}

\item{\code{envir}}{The environment in which to execute the instructions.}

\item{\code{force}}{A logical determining whether or not execution of the \code{source}
or \code{recipe} will be forced (i.e. happen whether or not the targets are
out-of-date)}

\item{\code{executed}}{A logical, whether or not the instructions were executed}

\item{\code{result}}{An object, whatever is returned by executing the instructions}

\item{\code{execution_time}}{A difftime, the time taken to execute the instructions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Segment-print"></a>}}
\if{latex}{\out{\hypertarget{method-Segment-print}{}}}
\subsection{Method \code{print()}}{
Printing method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Segment$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Segment-update_result"></a>}}
\if{latex}{\out{\hypertarget{method-Segment-update_result}{}}}
\subsection{Method \code{update_result()}}{
Update the Segment with new execution information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Segment$update_result(executed, execution_time, result)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{executed}}{A logical, whether or not the instructions were executed}

\item{\code{execution_time}}{A difftime, the time taken to execute the instructions}

\item{\code{result}}{An object, whatever is returned by executing the instructions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Segment-annotate"></a>}}
\if{latex}{\out{\hypertarget{method-Segment-annotate}{}}}
\subsection{Method \code{annotate()}}{
Apply annotations to Segment
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Segment$annotate(label = NULL, note = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{A short label for the segment}

\item{\code{note}}{A description of what the segment does}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Segment-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Segment-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Segment$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
