% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_km.R
\name{ph_diagplot}
\alias{ph_diagplot}
\title{Diagnosis plot of proportional hazard assumption for anchored and unanchored}
\usage{
ph_diagplot(
  weights_object,
  tte_ipd,
  tte_pseudo_ipd,
  trt_ipd,
  trt_agd,
  trt_common = NULL,
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  endpoint_name = "Time to Event Endpoint",
  time_scale,
  zph_transform = "log",
  zph_log_hazard = TRUE
)
}
\arguments{
\item{weights_object}{an object returned by \code{estimate_weight}}

\item{tte_ipd}{a data frame of individual patient data (IPD) of internal trial, contain at least "USUBJID", "EVENT",
"TIME" columns and a column indicating treatment assignment}

\item{tte_pseudo_ipd}{a data frame of pseudo IPD by digitized KM curves of external trial (for time-to-event
endpoint), contain at least "EVENT", "TIME"}

\item{trt_ipd}{a string, name of the interested investigation arm in internal trial \code{tte_ipd} (real IPD)}

\item{trt_agd}{a string, name of the interested investigation arm in external trial
\code{tte_pseudo_ipd} (pseudo IPD)}

\item{trt_common}{a string, name of the common comparator in internal and external trial, by default is NULL,
indicating unanchored case}

\item{trt_var_ipd}{a string, column name in \code{tte_ipd} that contains the treatment assignment}

\item{trt_var_agd}{a string, column name in \code{tte_pseudo_ipd} that contains the treatment assignment}

\item{endpoint_name}{a string, name of time to event endpoint, to be show in the last line of title}

\item{time_scale}{a string, time unit of median survival time, taking a value of 'years', 'months', 'weeks' or 'days'}

\item{zph_transform}{a string, pass to \code{survival::cox.zph}, default is "log"}

\item{zph_log_hazard}{a logical, if TRUE (default), y axis of the time dependent hazard function is log-hazard,
otherwise, hazard.}
}
\value{
a 3 by 2 plot, include log-cumulative hazard plot, time dependent hazard function and unscaled Schoenfeld
residual plot, before and after matching
}
\description{
Diagnosis plot of proportional hazard assumption for anchored and unanchored
}
\examples{
# unanchored example using ph_diagplot
data(weighted_sat)
data(adtte_sat)
data(pseudo_ipd_sat)

ph_diagplot(
  weights_object = weighted_sat,
  tte_ipd = adtte_sat,
  tte_pseudo_ipd = pseudo_ipd_sat,
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  trt_ipd = "A",
  trt_agd = "B",
  trt_common = NULL,
  endpoint_name = "Overall Survival",
  time_scale = "week",
  zph_transform = "log",
  zph_log_hazard = TRUE
)
# anchored example using ph_diagplot
data(weighted_twt)
data(adtte_twt)
data(pseudo_ipd_twt)

ph_diagplot(
  weights_object = weighted_twt,
  tte_ipd = adtte_twt,
  tte_pseudo_ipd = pseudo_ipd_twt,
  trt_var_ipd = "ARM",
  trt_var_agd = "ARM",
  trt_ipd = "A",
  trt_agd = "B",
  trt_common = "C",
  endpoint_name = "Overall Survival",
  time_scale = "week",
  zph_transform = "log",
  zph_log_hazard = TRUE
)
}
