% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animation.R
\name{animation}
\alias{animation}
\alias{image_animate}
\alias{image_coalesce}
\alias{image_morph}
\alias{image_mosaic}
\alias{image_flatten}
\alias{image_average}
\alias{image_append}
\alias{image_apply}
\alias{image_montage}
\title{Image Frames and Animation}
\usage{
image_animate(
  image,
  fps = 10,
  delay = NULL,
  loop = 0,
  dispose = c("background", "previous", "none"),
  optimize = FALSE
)

image_coalesce(image)

image_morph(image, frames = 8)

image_mosaic(image, operator = NULL)

image_flatten(image, operator = NULL)

image_average(image)

image_append(image, stack = FALSE)

image_apply(image, FUN, ...)

image_montage(
  image,
  geometry = NULL,
  tile = NULL,
  gravity = "Center",
  bg = "white",
  shadow = FALSE
)
}
\arguments{
\item{image}{magick image object returned by \code{\link[=image_read]{image_read()}} or \code{\link[=image_graph]{image_graph()}}}

\item{fps}{frames per second. Ignored if \code{delay} is not \code{NULL}.}

\item{delay}{delay after each frame, in 1/100 seconds.
Must be length 1, or number of frames. If specified, then \code{fps} is ignored.}

\item{loop}{how many times to repeat the animation. Default is infinite.}

\item{dispose}{a frame \href{https://legacy.imagemagick.org/Usage/anim_basics/#dispose}{disposal method}
from \link[=dispose_types]{dispose_types()}}

\item{optimize}{optimize the \code{gif} animation by storing only the differences
between frames. Input images must be exactly the same size.}

\item{frames}{number of frames to use in output animation}

\item{operator}{string with a
\href{https://www.imagemagick.org/Magick++/Enumerations.html#CompositeOperator}{composite operator}
from \link[=compose_types]{compose_types()}}

\item{stack}{place images top-to-bottom (TRUE) or left-to-right (FALSE)}

\item{FUN}{a function to be called on each frame in the image}

\item{...}{additional parameters for \code{FUN}}

\item{geometry}{a \link{geometry} string that defines the size the individual
thumbnail images, and the spacing between them.}

\item{tile}{a \link{geometry} string for example "4x5 with limits on how the
tiled images are to be laid out on the final result.}

\item{gravity}{a gravity direction, if the image is smaller than the frame, where
in the frame is the image to be placed.}

\item{bg}{a background color string}

\item{shadow}{enable shadows between images}
}
\description{
Operations to manipulate or combine multiple frames of an image. Details below.
}
\details{
For details see \href{https://www.imagemagick.org/Magick++/STL.html}{Magick++ STL}
documentation. Short descriptions:
\itemize{
\item \link{image_animate} coalesces frames by playing the sequence and converting to \code{gif} format.
\item \link{image_morph} expands number of frames by interpolating intermediate frames to blend
into each other when played as an animation.
\item \link{image_mosaic} inlays images to form a single coherent picture.
\item \link{image_montage} creates a composite image by combining frames.
\item \link{image_flatten} merges frames as layers into a single frame using a given operator.
\item \link{image_average} averages frames into single frame.
\item \link{image_append} stack images left-to-right (default) or top-to-bottom.
\item \link{image_apply} applies a function to each frame
}

The \link{image_apply} function calls an image function to each frame and joins
results back into a single image. Because most operations are already vectorized
this is often not needed. Note that \code{FUN()} should return an image. To apply other
kinds of functions to image frames simply use \link{lapply}, \link{vapply}, etc.
}
\examples{
# Combine images
logo <- image_read("https://jeroen.github.io/images/Rlogo.png")
oldlogo <- image_read("https://jeroen.github.io/images/Rlogo-old.png")

# Create morphing animation
both <- image_scale(c(oldlogo, logo), "400")
image_average(image_crop(both))
image_animate(image_morph(both, 10))

# Create thumbnails from GIF
banana <- image_read("https://jeroen.github.io/images/banana.gif")
length(banana)
image_average(banana)
image_flatten(banana)
image_append(banana)
image_append(banana, stack = TRUE)

# Append images together
wizard <- image_read("wizard:")
image_append(image_scale(c(image_append(banana[c(1,3)], stack = TRUE), wizard)))

image_composite(banana, image_scale(logo, "300"))

# Break down and combine frames
front <- image_scale(banana, "300")
background <- image_background(image_scale(logo, "400"), 'white')
frames <- image_apply(front, function(x){image_composite(background, x, offset = "+70+30")})
image_animate(frames, fps = 10)
# Simple 4x3 montage
input <- rep(logo, 12)
image_montage(input, geometry = 'x100+10+10', tile = '4x3', bg = 'pink', shadow = TRUE)

# With varying frame size
input <- c(wizard, wizard, logo, logo)
image_montage(input, tile = '2x2', bg = 'pink', gravity = 'southwest')
}
\seealso{
Other image: 
\code{\link{_index_}},
\code{\link{analysis}},
\code{\link{attributes}()},
\code{\link{color}},
\code{\link{composite}},
\code{\link{defines}},
\code{\link{device}},
\code{\link{edges}},
\code{\link{editing}},
\code{\link{effects}()},
\code{\link{fx}},
\code{\link{geometry}},
\code{\link{morphology}},
\code{\link{ocr}},
\code{\link{options}()},
\code{\link{painting}},
\code{\link{segmentation}},
\code{\link{transform}()},
\code{\link{video}}
}
\concept{image}
