\name{as.standard}
\alias{as.standard}
\alias{is.standard}

\title{Standard form for magic squares}
\description{
  Transforms a magic square or magic hypercube into
  Fr\'{e}nicle's standard form
}
\usage{
as.standard(a)
is.standard(a)
}
\arguments{
  \item{a}{Magic square or hypercube (array) to be tested or transformed}
}

\details{
For a square, \code{as.standard()} transforms a magic square into
Fr\'{e}nicle's standard form.  The four numbers at each of the four
corners are determined.  First, the square is rotated so the smallest of
the four is at the upper left.  Then, element \code{[1,2]} is compared
with element\code{[2,1]} and, if it is larger, the transpose is taken.

Thus all eight rotated and transposed versions of a magic square have
the same standard form.

The square returned by \code{magic()} is in standard form.

For hypercubes, the algorithm is generalized.  Firstly, the hypercube is
reflected so that \code{a[1,1,...,1,1]} is the smallest of the
\eqn{2^d}{2^d} corner elements (eg \code{a[1,n,1,...,1,1]}).

Next, \code{aperm()} is called so that

\code{a[1,1,...,1,2] < a[1,1,...,2,1] < ... < a[2,1,...,1,1]}.

Note that the inequalities are strict as hypercubes are assumed to be
normal.  As of version 1.3-1, \code{as.standard()} will accept arrays of
any dimension (ie arrays \code{a} with \code{minmax(dim(a))==FALSE} will
be handled sensibly).
  
\code{is.standard()} returns \code{TRUE} if the magic square or
hypercube is in standard form.  \code{is.standard()} and
\code{as.standard()} check for neither magicness nor normality (use
\code{\link{is.magic}} and \code{\link{is.normal}} for this).
}

\author{Robin K. S. Hankin}
\seealso{\code{\link{magic}},\ \code{\link{eq}}}
\examples{
is.standard(magic.2np1(4))
as.standard(magic.4n(3))

as.standard(magichypercube.4n(1,5))

##non-square arrays:
as.standard(magic(7)[1:3,])


}
\keyword{array}
