% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.magpie.R
\name{write.magpie}
\alias{write.magpie}
\title{Write MAgPIE-object to file}
\usage{
write.magpie(
  x,
  file_name,
  file_folder = "",
  file_type = NULL,
  append = FALSE,
  comment = NULL,
  comment.char = "*",
  metadata.char = "~",
  mode = NULL,
  nc_compression = 9,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{MAgPIE-object}

\item{file_name}{file name including file ending (wildcards are supported).
Optionally also the full path can be specified here (instead of splitting it
to file\_name and file\_folder)}

\item{file_folder}{folder the file should be written to (alternatively you
can also specify the full path in file\_name - wildcards are supported)}

\item{file_type}{Format the data should be stored as. Currently 12 formats
are available: "rds" (default R-data format), 
cs2" (cellular standard MAgPIE format), "csv" (regional standard MAgPIE 
format), "cs3" (Format for multidimensional MAgPIE data,
compatible to GAMS), "cs4" (alternative multidimensional format compatible
to GAMS, in contrast to cs3 it can also handle sparse data), "csvr", "cs2r",
"cs3r" and "cs4r" which are the same formats as the previous mentioned ones
with the only difference that they have a REMIND compatible format, "m"
(binary MAgPIE format "magpie"), "mz" (compressed binary MAgPIE format
"magpie zipped"), "asc" (ASCII grid format / only available for 0.5deg data)
and "nc" (netCDF format / only available for 0.5deg data). If
file\_type=NULL the file ending of the file\_name is used as format. If
format is different to the formats mentioned standard MAgPIE format is
assumed. Please be aware that the file\_name is independent of the
file\_type you choose here, so no additional file ending will be added!}

\item{append}{Decides whether an existing file should be overwritten (FALSE)
or the data should be added to it (TRUE). Append = TRUE only works if the
existing data can be combined with the new data using the mbind function}

\item{comment}{Vector of strings: Optional comment giving additional
information about the data. If different to NULL this will overwrite the
content of attr(x,"comment")}

\item{comment.char}{character: a character vector of length one containing a
single character or an empty string. Use "" to turn off the interpretation
of comments altogether.}

\item{metadata.char}{character: a character vector of length one containing a
single character or an empty string.}

\item{mode}{File permissions the file should be written with as 3-digit
number (e.g. "777" means full access for user, group and all, "750" means
full access for user, read access for group and no acess for anybody else).
Set to NULL system defaults will be used. Access codes are identical to the
codes used in unix function chmod.}

\item{nc_compression}{Only used if file\_type="nc". Sets the compression
level for netCDF files (default is 9). If set to an integer between 1 (least
compression) and 9 (most compression), the netCDF file is written in netCDF
version 4 format. If set to NA, the netCDF file is written in netCDF version
3 format.}

\item{verbose}{Boolean deciding about whether function should be verbose or not}

\item{...}{arguments to be passed to write.magpie.ncdf}
}
\description{
Writes a MAgPIE-3D-array (cells,years,datacolumn) to a file in one of three
MAgPIE formats (standard, "magpie", "magpie zipped")
}
\details{
This function can write 12 different MAgPIE file\_types. "cs2" is the new
standard format for cellular data with or without header and the first
columns (year,regiospatial) or only (regiospatial), "csv" is the standard
format for regional data with or without header and the first columns
(year,region,cellnumber) or only (region,cellnumber), "cs3" is another csv
format which is specifically designed for multidimensional data for usage in
GAMS.  All these variants are written without further specification. "rds" is
a R-default format for storing R objects.
"magpie" (.m) and "magpie zipped" (.mz) are new formats developed to allow a
less storage intensive management of MAgPIE-data. The only difference
between both formats is that .mz is gzipped whereas .m is not compressed. So
.mz needs less memory, whereas .m might have a higher compatibility to other
languages. "asc" is the ASCII grid format. "nc" is the netCDF format.  It
can only be applied for half degree data and writes one file per year per
data column. In the case that more than one year and data column is supplied
several files are written with the structure filename_year_datacolumn.asc
}
\note{
The binary MAgPIE formats .m and .mz have the following content/structure
(you only have to care for that if you want to implement
read.magpie/write.magpie functions in other languages): \cr \cr 
[ FileFormatVersion | Current file format version number (currently 4) | integer | 2 Byte ] \cr 
[ nchar_comment | Number of characters of the file comment | integer | 4 Byte ] \cr 
[ nbyte_metadata | Number of bytes of the serialized metadata | integer | 4 Byte ] \cr 
[ nchar_sets | Number of characters of all regionnames + 2 delimiter | integer | 2 Byte] \cr 
[ not used | Bytes reserved for later file format improvements | integer | 92 Byte ] \cr
[ nyears | Number of years | integer | 2 Byte ]\cr 
[ year_list | All years of the dataset (0, if year is not present) | integer | 2*nyears Byte ] \cr 
[ nregions | Number of regions | integer | 2 Byte ] \cr 
[ nchar_reg | Number of characters of all regionnames + (nreg-1) for delimiters | integer | 4 Byte ] \cr 
[ regions | Regionnames saved as reg1\\nreg2 (\\n is the delimiter) | character | 1*nchar_reg Byte ] \cr 
[ cpr | Cells per region | integer | 4*nreg Byte ] \cr 
[ nelem | Total number of data elements | integer | 4 Byte ] \cr 
[ nchar_data | Number of char. of all datanames + (ndata - 1) for delimiters | integer | 4 Byte ] \cr
[ datanames | Names saved in the format data1\\ndata2 (\\n as del.) | character | 1*nchar_data Byte ] \cr 
[ data | Data of the MAgPIE array in vectorized form | numeric | 4*nelem Byte ] \cr 
[ comment | Comment with additional information about the data | character | 1*nchar_comment Byte ] \cr 
[ sets | Set names with \\n as delimiter | character | 1*nchar_sets Byte] \cr
[ metadata | serialized metadata information | bytes | 1*nbyte_metadata Byte] \cr 

Please note that if your data in the spatial dimension is not ordered by
region name each new appearance of a region which already appeared before
will be treated and counted as a new region (e.g.
AFR.1,AFR.2,CPA.3,CPA.4,AFR.5 will count AFR twice and nregions will be set
to 3!).
}
\examples{

# a <- read.magpie("lpj_yield_ir.csv")
# write.magpie(a,"lpj_yield_ir.mz")

}
\seealso{
\code{"\linkS4class{magpie}"},
\code{\link{read.magpie}},\code{\link{mbind}},\code{\link{write.magpie.ncdf}}
}
\author{
Jan Philipp Dietrich, Stephen Bi
}
