% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest_orch_frequency.R
\name{suggest_orch_frequency}
\alias{suggest_orch_frequency}
\title{Suggest orchestrator frequency based on a schedule}
\usage{
suggest_orch_frequency(
  schedule,
  check_datetime = lubridate::now(tzone = "UTC")
)
}
\arguments{
\item{schedule}{MaestroSchedule object created by \code{build_schedule()}}

\item{check_datetime}{datetime against which to check the running of pipelines (default is current system time in UTC)}
}
\value{
frequency string
}
\description{
Suggests a frequency to run the orchestrator based on the frequencies of the
pipelines in a schedule.
}
\details{
This function attempts to find the smallest interval of time between all pipelines.
If the smallest interval is less than 15 minutes, it just uses the smallest interval.

Note this function is intended to be used interactively when deciding how often to
schedule the orchestrator. Programmatic use is not recommended.
}
\examples{

if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE)
  schedule <- build_schedule(pipeline_dir = pipeline_dir)
  suggest_orch_frequency(schedule)
}
}
