% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_schedule.R
\name{build_schedule}
\alias{build_schedule}
\title{Build a schedule table}
\usage{
build_schedule(pipeline_dir = "./pipelines", quiet = FALSE)
}
\arguments{
\item{pipeline_dir}{path to directory containing the pipeline scripts}

\item{quiet}{silence metrics to the console (default = \code{FALSE})}
}
\value{
data.frame
}
\description{
Builds a schedule data.frame for scheduling pipelines in \code{run_schedule()}.
}
\details{
This function parses the maestro tags of functions located in \code{pipeline_dir} which is
conventionally called 'pipelines'. An orchestrator requires a schedule table
to determine which pipelines are to run and when. Each row in a schedule table
is a pipeline name and its scheduling parameters such as its frequency.

The schedule table is mostly intended to be used by \code{run_schedule()} immediately.
In other words, it is not recommended to make changes to it.
}
\examples{

# Creating a temporary directory for demo purposes! In practice, just
# create a 'pipelines' directory at the project level.

if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE)
  build_schedule(pipeline_dir = pipeline_dir)
}
}
