% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-unit_checks.R
\name{check_dataset_variables}
\alias{check_dataset_variables}
\title{Assess a data dictionary and associated dataset for undeclared variables}
\usage{
check_dataset_variables(dataset, data_dict = NULL)
}
\arguments{
\item{dataset}{A tibble identifying the input dataset observations.}

\item{data_dict}{A list of tibble(s) representing meta data to be evaluated.}
}
\value{
A tibble providing undeclared variables across a data dictionary.
}
\description{
Generates a tibble report of any variable that is present in a dataset but
not in the associated data dictionary or present in a data dictionary but
not in the associated dataset.
This report can be used to help assess data structure, presence of fields,
coherence across elements, and taxonomy or data dictionary formats.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.

A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.
}
\examples{
{

# use DEMO_files provided by the package

dataset <- DEMO_files$`dataset_TOKYO - ERROR WITH DATA`
data_dict <- DEMO_files$`dd_TOKYO_format_maelstrom_tagged - ERROR`
check_dataset_variables(dataset,data_dict)

}

}
