% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolGetMapping.R
\name{toolGetMapping}
\alias{toolGetMapping}
\title{Tool: GetMapping}
\usage{
toolGetMapping(name, type = NULL, where = "mappingfolder",
  error.missing = TRUE, returnPathOnly = FALSE)
}
\arguments{
\item{name}{File name of the mapping file. Supported file types are currently csv (, or ; separated) 
and rda (which needs to have the data stored with the object name "data"!). Use code{\link{toolConvertMapping}}
to convert between both formats}

\item{type}{Mapping type (e.g. "regional", "cell", or "sectoral"). Can be set to NULL if file
is not stored in a type specific subfolder}

\item{where}{location to look for the mapping, either "mappingfolder" or
the name of a package which contains the mapping}

\item{error.missing}{Boolean which decides whether an error is returned if
the mapping file does not exist or not.}

\item{returnPathOnly}{If set to TRUE only the file path is returned}
}
\value{
the mapping as a data frame
}
\description{
Function which retrieves a mapping file
}
\examples{

toolGetMapping("regionmappingH12.csv", where="madrat")

}
\seealso{
\code{\link{calcOutput}}, \code{\link{toolConvertMapping}}
}
\author{
Jan Philipp Dietrich
}
