% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{wff3}
\alias{wff3}
\title{Weekly Fama French 3 Factor Returns}
\format{A \code{data.frame} object with 4800 observations and 5 columns.
The data run from July, 1926 through June, 2018.
As in the upstream source, the data are given in \emph{percents}, meaning a
value of 1.00 corresponds to a 1\% movement.
Note also that returns presumably are \sQuote{simple} returns, not log
returns, though this is not clarified by the upstream source.
The columns are defined as follows:
\describe{
 \item{\code{Date}}{The closing data, as a \code{Date} object. These are typically Saturdays.}
 \item{\code{Mkt}}{The Market weekly return. Note that the risk free rate has been added back
 to the excess returns published by the upstream source.}
 \item{\code{SMB}}{The cap factor weekly return.}
 \item{\code{HML}}{The growth factor weekly return.}
 \item{\code{RF}}{The risk-free rate, presumably as an weekly rate, though note that no corrections have been
 made for weekend effects when adding the risk-free rate back to the market
 rate.}
}}
\source{
Kenneth French data library, via Quandl. 
See \url{http://mba.tuck.dartmouth.edu/pages/faculty/ken.french/data_library.html},
data description at \url{http://mba.tuck.dartmouth.edu/pages/faculty/ken.french/Data_Library/f-f_factors.html}.
}
\usage{
wff3
}
\description{
The weekly returns of the 3 Fama French Factors: Market, the cap factor SMB, 
and the growth factor HML.
}
\examples{
data(wff3)
str(wff3)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{data}
