% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.r
\name{as.madness}
\alias{as.madness}
\alias{as.madness.default}
\title{Coerce to a madness object.}
\usage{
as.madness(x, vtag=NULL, xtag=NULL)

\method{as.madness}{default}(x, vtag = NULL, xtag = NULL)
}
\arguments{
\item{x}{an object which can be fed to \code{coef}, and possibly \code{vcov}}

\item{vtag}{an optional name for the \eqn{val} variable.}

\item{xtag}{an optional name for the \eqn{X} variable.}
}
\value{
A madness object.
}
\description{
Convert model to a madness object.
}
\details{
Attempts to stuff the coefficients and variance-covariance matrix of a model
into a madness object.
}
\examples{
xy <- data.frame(x=rnorm(100),y=runif(100),z=runif(100))
amod <- lm(z ~ x + y,xy)
amad <- as.madness(amod)
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}

