% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_macrosynteny.R
\name{reorder_macrosynteny}
\alias{reorder_macrosynteny}
\title{Reorder the mbh_df before plotting}
\usage{
reorder_macrosynteny(
  orthologs_df,
  pvalue_threshold = 0.001,
  keep_only_significant = FALSE
)
}
\arguments{
\item{orthologs_df}{dataframe. mutual best hits with genomic coordinates loaded with load_orthologs()}

\item{pvalue_threshold}{numeric. threshold for significancy. (default equals 0.001)}

\item{keep_only_significant}{logical. (default equals FALSE)}
}
\value{
A dataframe object
}
\description{
This is a function to reorder an orthologs_df, that was generated with load_orthologs(). It retrieves communities using igraph::cluster_fast_greedy.
}
\examples{
# basic usage of plot_oxford_grid : 

orthologs_table <- system.file("extdata","my_orthologs.tab",package="macrosyntR")

my_orthologs <- read.table(orthologs_table,header=TRUE)

my_orthologs_reordered <- reorder_macrosynteny(my_orthologs)

}
\seealso{
\code{\link[=load_orthologs]{load_orthologs()}}

\code{\link[=compute_macrosynteny]{compute_macrosynteny()}}
}
