% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreCI.R
\name{scoreCI}
\alias{scoreCI}
\alias{ciCollapse}
\title{Calculate confidence intervals by the Wilson Score method}
\usage{
scoreCI(p, n, z = 1.96, correct = FALSE)

ciCollapse(ci, sep = " - ", rnd = 2, bracket = TRUE)
}
\arguments{
\item{p}{proportion}

\item{n}{sample size}

\item{z}{confidence level}

\item{correct}{a logical indicating whether to apply continuity correction}

\item{ci}{a vector of two values (lower and upper CI values)}

\item{sep}{separator for line break}

\item{rnd}{specify rounding of numbers. See \code{\link{round}}.}

\item{bracket}{a logical indicating whether to paste bracket to ci values}
}
\description{
\code{scoreCI()} generates confidence intervals by the
Wilson Score method

\code{ciCollapse} formats two values in this format
\code{(##.# - ##.#)}.
}
\details{
\code{scoreCI}

The Wilson score interval is an improvement over the normal approximation
interval in that the actual coverage probability is closer to the nominal
value. It was developed by Edwin Bidwell Wilson (1927). (Wikipedia)

\strong{Reference:}
\enumerate{
\item Brown, Lawrence D.; Cai, T. Tony; DasGupta, Anirban (2001). "Interval
Estimation for a Binomial Proportion". Statistical Science. 16 (2): 101–133.
\item Wallis, Sean A. (2013). "Binomial confidence intervals and contingency
tests: mathematical fundamentals and the evaluation of alternative methods"
.Journal of Quantitative Linguistics. 20 (3): 178–208.
\item Newcombe, R. G. (1998). "Two-sided confidence intervals for the single
proportion: comparison of seven methods". Statistics in Medicine. 17 (8):
857–872. doi:10.1002/(SICI)1097-0258(19980430)17:8<857::AID-SIM777>3.0.CO;2-E.
PMID 9595616.
}
}
\examples{

scoreCI(.20, 200)
scoreCI(.20, 200, correct = TRUE)

}
\seealso{
\code{\link{diagTest}}
}
\author{
For any feedback, please contact \code{Myo Minn Oo} via:

Email: \email{dr.myominnoo@gmail.com}

Website: \url{https://myominnoo.github.io/}
}
