% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-attachments.R
\name{get_attachments}
\alias{get_attachments}
\title{Get Attachments}
\usage{
get_attachments(msg_list)
}
\arguments{
\item{msg_list}{A \code{list} containing the full messages fetched from
the server after using \code{\link{fetch_full_msg}}.}
}
\value{
A logical \code{TRUE} if the attachments extraction was successful.
}
\description{
Get attachments after fetching full messages.
}
\note{
All attachments will be stored in a folder labelled with the message id
    inside the working directory. This function currently handles only attachments
    encoded as \code{base64} text. It tries to guess all file extensions while decoding
    the text, but it may not be possible in some circumstances. In those cases,
    you can try to change the file extension directly by renaming the file.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )

# extracting attachments
imapconf \%>\%
    select_mailbox(mbox = "TAM") \%>\%
    search_before(date_char = "10-may-2012", by = "UID") \%$\% #exposition pipe - two argg
    fetch_full_msgs(imapconf = imapconf, msg_id = msg_id) \%>\%
    get_attachments()

}

}
\seealso{
Other attachments: \code{\link{list_attachments}}
}
\concept{attachments}
