% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_fhill_ind_computation.R
\name{beta.fd.hill}
\alias{beta.fd.hill}
\title{Compute Functional beta-Diversity indices based on Hill Numbers}
\usage{
beta.fd.hill(
  asb_sp_w,
  sp_dist,
  q = c(0, 1, 2),
  tau = "mean",
  beta_type = "Jaccard",
  check_input = TRUE,
  details_returned = TRUE
)
}
\arguments{
\item{asb_sp_w}{a matrix with weight of species (columns) in a set
of assemblages (rows). Rows and columns should have names. NA are not
allowed.}

\item{sp_dist}{a matrix or dist object with distance between
species. Species names should be provided and match those in 'asb_sp_w'.
NA are not allowed.}

\item{q}{a vector containing values referring to the order of
diversity to use}

\item{tau}{a character string with name of function to apply to
distance matrix (i.e. among all pairs of species) to get the threshold
used to define 'functionally indistinct set of species'. Could be qet to
'mean' (default), 'min' or 'max'.}

\item{beta_type}{a character string with name of framework used for
computing beta-diversity, either 'Jaccard' (default) or 'Sorensen'.}

\item{check_input}{a logical value indicating whether key features the
inputs are checked (e.g. class and/or mode of objects, names of rows
and/or columns, missing values). If an error is detected, a detailed
message is returned. Default: \code{check_input = TRUE}.}

\item{details_returned}{a logical value indicating whether the user
want to store values used for computing indices (see list below)}
}
\value{
A list with:
\itemize{
\item \emph{asb_FDbeta} a list with for each value of q a \emph{dist}
object with beta functional diversity indices for all pairs of assemblages
item if \strong{store.details} turned to TRUE a list \emph{details} with
\itemize{
\item \emph{malpha_fd_q} a list with for each value of q a \emph{dist}
object with mean alpha functional diversity indices for all pairs of
assemblages
\item \emph{gamma_fd_q} a list with for each value of q a \emph{dist}
object with gamma functional diversity indices for all pairs of assemblages
}
}
}
\description{
Compute functional beta-diversity indices based on Hill numbers applied to
distance between species following the framework from Chao \emph{et al.} (2019).
}
\note{
When q=1 Jaccard-like and Sorensen-like beta-diversity are identical.
FD computed with tau='min' is equivalent to Hill number taxonomic beta
diversity. If tau='min' and there are species with null distance, tau is
set to the minimum non-null value and a warning message is displayed.
Indices values are stored as \emph{dist} objects to optimize memory.
See below example of how merging distance values in a \emph{dataframe} with
\code{\link{dist.to.df}}
}
\examples{
# Load Species*Traits dataframe:
data('fruits_traits', package = 'mFD')

# Load Traits types dataframe:      
data('fruits_traits_cat', package = 'mFD')
   
# Compute functional distance 
sp_dist_fruits <- mFD::funct.dist(sp_tr         = fruits_traits,
                                  tr_cat        = fruits_traits_cat,
                                  metric        = "gower",
                                  scale_euclid  = "scale_center",
                                  ordinal_var   = "classic",
                                  weight_type   = "equal",
                                  stop_if_NA    = TRUE)

# Compute beta functional hill indices:
baskets_beta <- beta.fd.hill(
      asb_sp_w         = baskets_fruits_weights, 
      sp_dist          = sp_dist_fruits, 
      q                = c(0,1,2), 
      tau              = 'mean',
      beta_type        = 'Jaccard', 
      check_input      = TRUE, 
      details_returned = TRUE)
 
# Then use the mFD::dist.to.df function to ease visualizing result:
## for q = 0:
mFD::dist.to.df(list_dist = list(FDq2 = baskets_beta$beta_fd_q$q0))
## for q = 1:
mFD::dist.to.df(list_dist = list(FDq2 = baskets_beta$beta_fd_q$q1))
## for q = 2:
mFD::dist.to.df(list_dist = list(FDq2 = baskets_beta$beta_fd_q$q2))
}
\references{
Chao \emph{et al.} (2019) An attribute diversity approach to functional
diversity, functional beta diversity, and related (dis)similarity
measures. \emph{Ecological Monographs}, \strong{89}, e01343.
}
\author{
Sebastien Villeger and Camille Magneville
}
