% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_bland_altman.R
\name{plot_bland_altman}
\alias{plot_bland_altman}
\title{Create a Bland-Altman plot}
\usage{
plot_bland_altman(x, ...)
}
\arguments{
\item{x}{An object of class \code{lvmisc_cv} or an object containing a model.}

\item{...}{Additional arguments to be passed to \code{ggplot2::aes()}.}
}
\value{
A \code{ggplot} object.
}
\description{
Create a Bland-Altman plot as described by Bland & Altman (1986).
}
\examples{
mtcars <- tibble::as_tibble(mtcars, rownames = "car")
m <- stats::lm(disp ~ mpg, mtcars)
cv <- loo_cv(m, mtcars, car)
plot_bland_altman(cv, colour = as.factor(am))
}
\references{
\itemize{
\item Bland, J.M. & Altman, D.G. (1986). Statistical methods for assessing
agreement between two methods of clinical measurement.
Lancet, 8(1), 307-10. \doi{https://doi.org/10.1016/S0140-6736(86)90837-8}
}
}
