% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo_cv.R
\name{loo_cv}
\alias{loo_cv}
\alias{loo_cv.default}
\alias{loo_cv.lm}
\alias{loo_cv.lmerMod}
\title{Leave-one-out cross-validation}
\usage{
loo_cv(model, data, id, keep = "all")

\method{loo_cv}{default}(model, data, id, keep = "all")

\method{loo_cv}{lm}(model, data, id, keep = "all")

\method{loo_cv}{lmerMod}(model, data, id, keep = "all")
}
\arguments{
\item{model}{An object containing a model.}

\item{data}{A data frame.}

\item{id}{The bare (unquoted) name of the column which identifies subjects.}

\item{keep}{A character string which controls which columns are present in
the output. Can be one of three options:
\itemize{
\item \code{"all"}: The default. Retain all variables in the original data frame
plus the \code{".actual"} and \code{".predicted"} columns.
\item \code{"used"}: Keeps only the \code{"id"} column of the original data frame, plus
the \code{".actual"} and \code{".predicted"} columns.
\item \code{"none"}: Returns just the \code{".actual"} and `".predicted" columns.
}}
}
\value{
Returns an object of class \code{lvmisc_cv}. A tibble containing the
\code{".actual"} and \code{".predicted"} columns.
}
\description{
Cross-validates the model using the leave-one-out approach. In this method
each subject's data is separated into a testing data set, and all other
subject's are kept in the training data set, with as many resamples as
the number of subjects in the original data set. It computes the model's
predicted value in the testing data set for each subject.
}
\examples{
mtcars$car <- row.names(mtcars)
m <- stats::lm(disp ~ mpg, mtcars)
loo_cv(m, mtcars, car, keep = "used")
}
