% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_proj.R
\name{create_proj}
\alias{create_proj}
\title{Create a project}
\usage{
create_proj(
  path,
  sub_dirs = "default",
  use_git = TRUE,
  use_gitignore = "default",
  use_readme = TRUE
)
}
\arguments{
\item{path}{A path to a directory that does not exist.}

\item{sub_dirs}{A character vector. If \code{sub_dirs = "default"}, it
creates 'code/', 'data/', 'docs/', 'figures/' and 'tables/'
sub-directories. Otherwise, it creates the sub-directories specified
in the character vector.}

\item{use_git}{A logical value indicating whether or not to initialize a git
repository. Defaults to \code{TRUE}.}

\item{use_gitignore}{A character vector. If \code{use_gitignore = "default"},
it adds a .gitignore file with the files generated by your operating
system and by R, as well as some common file extensions. The default
.gitignore is as generated by
\href{https://www.toptal.com/developers/gitignore}{gitignore.io}. To
create a custom .gitignore, add the files to be ignored in a character
vector. If you do not want to create a .gitignore file, set
\code{use_gitignore = NULL}.}

\item{use_readme}{A logical value. If \code{TRUE} (default), adds an empty
'README.md' file.}
}
\value{
Path to the newly created project, invisibly.
}
\description{
Creates a project structure, including sub-directories, and initialization
of a git repository.
}
