% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{center_variable}
\alias{center_variable}
\title{Center variable}
\usage{
center_variable(variable, scale = FALSE, by = NULL)
}
\arguments{
\item{variable}{A numeric vector.}

\item{scale}{A logical vector. If \code{scale = TRUE}, the centered values
of \code{variable} are divided by their standard deviation.}

\item{by}{A vector with the \code{factor} class.}
}
\value{
A numeric vector.
}
\description{
Center a variable by subtracting the mean from each element. Centering can
be performed by the grand mean when \code{by = NULL} (the default), or by
group means when \code{by} is a factor variable.
}
\examples{
df <- data.frame(
  id = 1:20,
  group = as.factor(sample(c("A", "B"), 20, replace = TRUE)),
  body_mass = rnorm(20, mean = 65, sd = 12)
)

df$body_mass_centered <- center_variable(df$body_mass, by = df$group)
df
}
