% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeat_baseline_values.R
\name{repeat_baseline_values}
\alias{repeat_baseline_values}
\title{Repeat baseline levels}
\usage{
repeat_baseline_values(data, var, id, time, baseline_level, repeat_NA = TRUE)
}
\arguments{
\item{data}{A data frame.}

\item{var}{The bare (unquoted) name of the column with the values to be
repeated.}

\item{id}{The bare (unquoted) name of the column that identifies each
subject.}

\item{time}{The bare (unquoted) name of the column with the time values.}

\item{baseline_level}{The value of \code{time} corresponding the baseline.}

\item{repeat_NA}{A logical vector indicating whether or not \code{NA} values
in the \code{var} will correspond to \code{NA} values in return vector.
Defaults to \code{TRUE}.}
}
\value{
A vector of the same lenght and class of \code{var}.
}
\description{
Returns a vector with the length equal to the number of rows in the
\code{data} with the baseline value of the \code{var} repeated for every
\code{time} value of each \code{id}.
}
\examples{
df <- data.frame(
 id = rep(1:5, each = 4),
 time = rep(1:4, 5),
 score = rnorm(20, mean = 10, sd = 2)
)

df$baseline_score <- repeat_baseline_values(df, score, id, time, 1)
df
}
