% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmi.R
\name{bmi}
\alias{bmi}
\title{Compute body mass index (BMI)}
\usage{
bmi(mass, height)
}
\arguments{
\item{mass, height}{A numerical vector with body mass and height data. \code{mass}
unit must be kilograms and \code{height} unit must be meters. If the \code{height}
unit is centimeters, it is converted to meters before BMI computation and
a warning is shown.}
}
\value{
Returns a double vector with the element-wise body mass index (BMI).
}
\description{
\code{bmi} calculates the BMI in kilograms per meter squared.
}
\examples{
mass <- sample(50:100, 20)
height <- rnorm(20, mean = 1.7, sd = 0.2)

bmi(mass, height)
}
\seealso{
\code{\link[=bmi_cat]{bmi_cat()}}
}
