#' PPI genetic interactions
#' 
#' The dataset contains a network formed by genetic protein-protein
#' interactions (PPI) between 67 Saccharomyces cerevisiae proteins.
#' The network is formed of 294 links.
#' The data were downloaded from the Biological General Repository for
#' Interaction Datasets (BioGRID) database \url{http://thebiogrid.org/}
#' 
#' Binary adjacency matrix containing genetic interactions between 67 proteins.
#' 
#' @references Gollini, I., and Murphy, T. B. (2016), 'Joint Modelling of Multiple Network Views', Journal of Computational and Graphical Statistics, 25(1), 246-265 \url{http://arxiv.org/abs/1301.3759}.
#' @docType data
#' @seealso \code{\link{PPIphy}}
#' @keywords datasets
#' @format Binary adjacency matrix
#' @name PPIgen
"PPIgen"
