% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/goflsm.R
\name{goflsm}
\alias{goflsm}
\title{Goodness-of-Fit diagnostics for LSM model}
\usage{
goflsm(object, Y, Ysim = NULL, nsim = 100, seed, directed = NULL,
  stats = NULL, doplot = TRUE, parm = TRUE)
}
\arguments{
\item{object}{object of class \code{'lsm'}}

\item{Y}{(\code{N} x \code{N}) binary adjacency matrix}

\item{Ysim}{list containing simulated (\code{N} x \code{N}) adjacency marices.  Default \code{Ysim = NULL}}

\item{nsim}{number of simulations. Default \code{nsim = 100}}

\item{seed}{for simulations}

\item{directed}{if the network is directed or not.  Default \code{directed = NULL}}

\item{stats}{statistics used. Default \code{stats = NULL}}

\item{doplot}{draw boxplot.  Default \code{doplot = TRUE}}

\item{parm}{do all the plots in one window. Default \code{parm = TRUE}}
}
\description{
This function produces goodness-of-fit diagnostics for LSM model.
}
\examples{
Y <- network(15, directed = FALSE)[,]

modLSM <- lsm(Y, D = 2)
myGof <- goflsm(modLSM, Y = Y)
}
\seealso{
\code{\link{lsm}}, \code{\link{simulateLSM}}, \code{\link{plot.gofobj}}, \code{\link{print.gofobj}}
}

