% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialization.R
\name{luz_save}
\alias{luz_save}
\title{Saves luz objects to disk}
\usage{
luz_save(obj, path, ...)
}
\arguments{
\item{obj}{an object of class 'luz_module_fitted' as returned by
\code{\link[=fit.luz_module_generator]{fit.luz_module_generator()}}.}

\item{path}{path in file system so save the object.}

\item{...}{currently unused.}
}
\description{
Allows saving luz fitted models to the disk. Objects can be loaded back with
\code{\link[=luz_load]{luz_load()}}.
}
\note{
Objects are saved as plain \code{.rds} files but \code{obj$model} is serialized
with \code{torch_save} before saving it.
}
\section{Warning}{

The \link{ctx} is naively serialized. Ie, we only use \code{\link[=saveRDS]{saveRDS()}} to serialize it.
Don't expect \code{luz_save} to work correctly if you have unserializable objects
in the \link{ctx} like \code{torch_tensor}s and external pointers in general.
}

\seealso{
Other luz_save: 
\code{\link{luz_load}()}
}
\concept{luz_save}
