% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\docType{methods}
\name{resample,ExpVarRasterList,Raster-method}
\alias{resample,ExpVarRasterList,Raster-method}
\alias{resample,list,Raster-method}
\title{Resample maps in ExpVarRasterList object or list}
\usage{
\S4method{resample}{ExpVarRasterList,Raster}(x, y, method = "ngb", ...)

\S4method{resample}{list,Raster}(x, y, method = "ngb", ...)
}
\arguments{
\item{x}{an ExpVarRasterList object or list of Raster* maps to be resampled}

\item{y}{Raster* object with parameters that \code{x} should be resampled to}

\item{method}{method used to compute values for the new RasterLayer, should be
\code{"bilinear"} for bilinear interpolation, or \code{"ngb"} for nearest
neighbour}

\item{\dots}{additional arguments to \code{raster::\link[raster]{resample}}}
}
\value{
An ExpVarRasterList object or list, depending on \code{x}.
}
\description{
A wrapper function for \code{raster::\link[raster]{resample}} to resample
raster objects in an ExpVarRasterList object or list.
}
\examples{

\dontrun{

## Plum Island Ecosystems

## observed data
obs <- ObsLulcRasterStack(x=pie,
                    pattern="lu",
                    categories=c(1,2,3),
                    labels=c("forest","built","other"),
                    t=c(0,6,14))

## explanatory variables
ef <- ExpVarRasterList(x=pie, pattern="ef")

## resample to ensure maps have same characteristics as observed maps
ef <- resample(x=ef, y=obs, method="ngb")

}
}
\seealso{
\code{\link{ExpVarRasterList}}, \code{raster::\link[raster]{resample}}
}
