% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsirm2pl_normal_mar.R
\name{lsirm2pl_normal_mar}
\alias{lsirm2pl_normal_mar}
\title{2pl LSIRM model with normal likelihood and missing at random data.}
\usage{
lsirm2pl_normal_mar(
  data,
  ndim = 2,
  niter = 15000,
  nburn = 2500,
  nthin = 5,
  nprint = 500,
  jump_beta = 0.4,
  jump_theta = 1,
  jump_alpha = 1,
  jump_gamma = 1,
  jump_z = 0.5,
  jump_w = 0.5,
  pr_mean_beta = 0,
  pr_sd_beta = 1,
  pr_mean_theta = 0,
  pr_mean_gamma = 0.5,
  pr_sd_gamma = 1,
  pr_mean_alpha = 0.5,
  pr_sd_alpha = 1,
  pr_a_theta = 0.001,
  pr_b_theta = 0.001,
  pr_a_eps = 0.001,
  pr_b_eps = 0.001,
  missing.val = 99
)
}
\arguments{
\item{data}{Matrix; continuous item response matrix to be analyzed. Each row is assumed to be respondent and its column values are assumed to be response to the corresponding item.}

\item{ndim}{Numeric; dimension of latent space. default value is 2.}

\item{niter}{Numeric; number of iterations to run MCMC sampling. default value is 15000.}

\item{nburn}{Numeric; number of initial, pre-thinning, MCMC iterations to discard. default value is 2500.}

\item{nthin}{Numeric;number of thinning, MCMC iterations to discard. default value is 5.}

\item{nprint}{Numeric; MCMC samples is displayed during execution of MCMC chain for each \code{nprint}. default value is 500.}

\item{jump_beta}{Numeric; jumping rule of the proposal density for beta. default value is 0.4.}

\item{jump_theta}{Numeric; jumping rule of the proposal density for theta. default value is 1.0.}

\item{jump_alpha}{Numeric; jumping rule of the proposal density for alpha default value is 1.0.}

\item{jump_gamma}{Numeric; jumping rule of the proposal density for gamma. default value is 0.025.}

\item{jump_z}{Numeric; jumping rule of the proposal density for z. default value is 0.5.}

\item{jump_w}{Numeric; jumping rule of the proposal density for w. default value is 0.5.}

\item{pr_mean_beta}{Numeric; mean of normal prior for beta. default value is 0.}

\item{pr_sd_beta}{Numeric; standard deviation of normal prior for beta. default value is 1.0.}

\item{pr_mean_theta}{Numeric; mean of normal prior for theta. default value is 0.}

\item{pr_mean_gamma}{Numeric; mean of log normal prior for gamma. default value is 0.5.}

\item{pr_sd_gamma}{Numeric; standard deviation of log normal prior for gamma. default value is 1.0.}

\item{pr_mean_alpha}{Numeric; mean of normal prior for alpha. default value is 0.5.}

\item{pr_sd_alpha}{Numeric; mean of normal prior for beta. default value is 1.0.}

\item{pr_a_theta}{Numeric; shape parameter of inverse gamma prior for variance of theta. default value is 0.001.}

\item{pr_b_theta}{Numeric; scale parameter of inverse gamma prior for variance of theta. default value is 0.001.}

\item{pr_a_eps}{Numeric; shape parameter of inverse gamma prior for variance of data likelihood. default value is 0.001.}

\item{pr_b_eps}{Numeric; scale parameter of inverse gamma prior for variance of data likelihood default value is 0.001.}

\item{missing.val}{Numeric; a number to replace missing values. default value is 99.}
}
\value{
\code{lsirm2pl_normal_mar} returns an object of  list containing the following components:
 \item{data}{data frame or matrix containing the variables in the model.}
 \item{missing.val}{a number to replace missing values.}
 \item{bic}{Numeric value with the corresponding BIC.}
 \item{mcmc_inf}{number of mcmc iteration, burn-in periods, and thinning intervals.}
 \item{map_inf}{value of log maximum a posterior and iteration number which have log maximum a posterior.}
 \item{beta_estimate}{posterior estimation of beta.}
 \item{theta_estimate}{posterior estimation of theta.}
 \item{sigma_theta_estimate}{posterior estimation of standard deviation of theta.}
 \item{sigma_estimate}{posterior estimation of standard deviation.}
 \item{gamma_estimate}{posterior estimation of gamma.}
 \item{alpha_estimate}{posterior estimation of alpha.}
 \item{imp_estimate}{estimation of imputing missing values.}
 \item{z_estimate}{posterior estimation of z.}
 \item{w_estimate}{posterior estimation of w.}
 \item{beta}{posterior samples of beta.}
 \item{theta}{posterior samples of theta.}
 \item{theta_sd}{posterior samples of standard deviation of theta.}
 \item{sigma}{posterior samples of standard deviation.}
 \item{gamma}{posterior samples of gamma.}
 \item{alpha}{posterior samples of alpha.}
 \item{imp}{imputation for missing Values using posterior samples.}
 \item{z}{posterior samples of z. The output is 3-dimensional matrix with last axis represent the dimension of latent space.}
 \item{w}{posterior samples of w. The output is 3-dimensional matrix with last axis represent the dimension of latent space.}
 \item{accept_beta}{accept ratio of beta.}
 \item{accept_theta}{accept ratio of theta.}
 \item{accept_w}{accept ratio of w.}
 \item{accept_z}{accept ratio of z.}
 \item{accept_gamma}{accept ratio of gamma.}
 \item{accept_alpha}{accept ratio of alpha.}
}
\description{
\link{lsirm2pl_normal_mar} is used to fit 2pl LSIRM model for continuous variable in incomplete data assumed to be missing at random.
\link{lsirm2pl_normal_mar} factorizes item response matrix into column-wise item effect, row-wise respondent effect and further embeds interaction effect in a latent space, while considering the missing element under the assumption of missing at random. Unlike 1pl model, 2pl model assumes the item effect can vary according to respondent, allowing additional parameter multiplied with respondent effect. The resulting latent space provides an interaction map that represents interactions between respondents and items.
}
\details{
\code{lsirm2pl_normal_mar} models the continuous value of response by respondent \eqn{j} to item \eqn{i} with item effect \eqn{\beta_i}, respondent effect \eqn{\theta_j} and the distance between latent position \eqn{w_i} of item \eqn{i} and latent position \eqn{z_j} of respondent \eqn{j} in the shared metric space, with \eqn{\gamma} represents the weight of the distance term. For 2pl model, the the item effect is assumed to have additional discrimination parameter \eqn{\alpha_i} multiplied by \eqn{\theta_j}: \deqn{Y_{j,i} = \theta_j+\beta_i-\gamma||z_j-w_i|| + e_{j,i}} where the error \eqn{e_{j,i} \sim N(0,\sigma^2)} Under the assumption of missing at random, the model takes the missing element into consideration in the sampling procedure. For the details of missing at random assumption and data augmentation, see References.
}
\examples{
# generate example (continuous) item response matrix
data     <- matrix(rnorm(500, mean = 0, sd = 1),ncol=10,nrow=50)

# generate example missing indicator matrix
missing_mat     <- matrix(rbinom(500, size = 1, prob = 0.2),ncol=10,nrow=50)

# make missing value with missing indicator matrix
data[missing_mat==1] <- 99

lsirm_result <- lsirm2pl_normal_mar(data)

# The code following can achieve the same result.
lsirm_result <- lsirm(data ~ lsirm2pl(spikenslab = FALSE, fixed_gamma = FALSE,
                      missing_data = "mar"))
}
\references{
Little, R. J., & Rubin, D. B. (2019). Statistical analysis with missing data (Vol. 793). John Wiley & Sons.
}
