% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/orc.lsbclust.R
\name{orc.lsbclust}
\alias{orc.lsbclust}
\title{K-means on the Overall Mean, Row Margins or Column Margins}
\usage{
orc.lsbclust(data, margin = 3L, delta, nclust, sep.nclust = TRUE,
  type = NULL, ...)
}
\arguments{
\item{data}{A three-way array representing the data.}

\item{margin}{An integer giving the single subscript of \code{data} over which the clustering
will be applied.}

\item{delta}{A four-element binary vector (logical or numeric) indicating which sum-to-zero
constraints must be enforced.}

\item{nclust}{An integer giving the desired number of clusters. In case \code{type} specifies
more than one method, \code{nclust} can be a vector containing the number of
clusters to be determined for each type of cluster, and in the correct order as determined by
\code{type} (after matching the arguments). If \code{type} is of length greater than one and
\code{nclust} is of length one, the behaviour is governed by \code{sep.nclust}.}

\item{sep.nclust}{Logical indicating how nclust should be used across different \code{type}'s.
If \code{sep.nclust} is \code{TRUE}, \code{nclust} is recycled so that each \code{type} can
have a different number of clusters. If \code{sep.nclust} is \code{FALSE}, the same vector
\code{nclust} is used for all \code{type}'s.}

\item{type}{One of \code{"overall"}, \code{"rows"} or \code{"columns"} (or a unique abbreviation of
one of these) indicating whether clustering should be done on row margins, column margins or
the overall means of the two-way slices respectively. If more than one opion are supplied, the
algorithm is run for all (unique) options supplied.}

\item{\dots}{Additional arguments passed to \code{\link{kmeans}}.}
}
\value{
A list of a subset of the classes \code{row.kmeans}, \code{col.kmeans} and
\code{ovl.kmeans} inheriting from class \code{kmeans}. In case \code{type} is a vector, a list
is returned containing the results for each of the (unique) elements of \code{type}, with the
same classes as before.
}
\description{
This function conducts k-means on the overall mean, the row margins or column margins of a set
of N matrices. These matrices are two-way slices of a three-dimensional array.
}

