% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignMeans.R
\name{getDesignTwoWayANOVA}
\alias{getDesignTwoWayANOVA}
\title{Power and sample size for two-way ANOVA}
\usage{
getDesignTwoWayANOVA(
  beta = NA_real_,
  n = NA_real_,
  nlevelsA = 2,
  nlevelsB = 2,
  means = NA_real_,
  stDev = 1,
  rounding = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{nlevelsA}{The number of groups for Factor A.}

\item{nlevelsB}{The number of levels for Factor B.}

\item{means}{The matrix of treatment means for Factors A and B
combination.}

\item{stDev}{The common standard deviation.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The two-sided significance level. Defaults to 0.05.}
}
\value{
An S3 class \code{designTwoWayANOVA} object with the following
components:
\itemize{
\item \code{alpha}: The two-sided significance level.
\item \code{nlevelsA}: The number of levels for Factor A.
\item \code{nlevelsB}: The number of levels for Factor B.
\item \code{means}: The matrix of treatment group means.
\item \code{stDev}: The common standard deviation.
\item \code{effectsizeA}: The effect size for Factor A.
\item \code{effectsizeB}: The effect size for Factor B.
\item \code{effectsizeAB}: The effect size for Factor A and Factor B
interaction.
\item \code{calculationTarget}: The calculation target, \code{beta} or
\code{n}.
\item \code{rounding}: Whether to round up sample size.
\item \code{powerdf}: The data frame containing the power and sample size
results. It has the following variables:
\itemize{
\item \code{n}: The sample size.
\item \code{powerA}: The power to reject the null hypothesis that
there is no difference among Factor A levels.
\item \code{powerB}: The power to reject the null hypothesis that
there is no difference among Factor B levels.
\item \code{powerAB}: The power to reject the null hypothesis that
there is no interaction between Factor A and Factor B.
}
}
}
\description{
Obtains the power and sample size for two-way
analysis of variance.
}
\examples{

(design1 <- getDesignTwoWayANOVA(
  beta = 0.1, nlevelsA = 2, nlevelsB = 2,
  means = matrix(c(0.5, 4.7, 0.4, 6.9), 2, 2, byrow = TRUE),
  stDev = 2, alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
