% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{remlRiskDiff}
\alias{remlRiskDiff}
\title{REML Estimates of Individual Proportions With Specified Risk
difference}
\usage{
remlRiskDiff(
  riskDiffH0 = 0,
  n1 = NA_real_,
  y1 = NA_real_,
  n2 = NA_real_,
  y2 = NA_real_
)
}
\arguments{
\item{riskDiffH0}{The specified risk difference.}

\item{n1}{The sample size for the active treatment group.}

\item{y1}{The number of responses for the active treatment group.}

\item{n2}{The sample size for the control group.}

\item{y2}{The number of responses for the control group.}
}
\value{
A vector of the restricted maximum likelihood estimates
of the response probabilities for the two treatment groups.
}
\description{
Obtains the restricted maximum likelihood estimates of
individual proportions with specified risk difference.
}
\examples{

remlRiskDiff(riskDiffH0 = 0.1, n1 = 10, y1 = 4, n2 = 20, y2 = 0)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
