# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Update graph for graphical approaches
#' @description Updates the weights and transition matrix for graphical 
#' approaches.
#'
#' @param w The current vector of weights for elementary hypotheses.
#' @param G The current transition matrix.
#' @param I The set of indices for yet to be rejected hypotheses.
#' @param j The hypothesis to remove from index set \code{I}.
#'
#' @return A list containing the new vector of weights and the new 
#' transition matrix for the graph, and the new set of indices of yet 
#' to be rejected hypotheses.
#'
#' @examples
#' updateGraph(w = c(0.5, 0.5, 0, 0), 
#'             G = matrix(c(0, 0.5, 0.5, 0,  0.5, 0, 0, 0.5,  
#'                          0, 1, 0, 0,  1, 0, 0, 0), 
#'                        nrow=4, ncol=4, byrow=TRUE), 
#'             I = c(1, 2, 3, 4), 
#'             j = 1)
#'
#' @export
updateGraph <- function(w, G, I, j) {
    .Call(`_lrstat_updateGraph`, w, G, I, j)
}

fadjpboncpp <- function(w, G, p) {
    .Call(`_lrstat_fadjpboncpp`, w, G, p)
}

#' @title Get efficacy boundaries for group sequential design
#' @description Obtains the efficacy stopping boundaries for a group
#' sequential design.
#'
#' @param k Look number for the current analysis.
#' @param informationRates Information rates up to the current look, must be
#'   increasing and less than or equal to 1.
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @param spendingTime A vector of length \code{k} for the error spending  
#'   time at each analysis, must be increasing and less than or equal to 1. 
#'   Defaults to missing, in which case, it is the same as 
#'   \code{informationRates}.
#'
#' @return A numeric vector of critical values up to the current look.
#'
#' @examples
#'
#' getBound(k = 2, informationRates = c(0.5,1),
#'          alpha = 0.025, typeAlphaSpending = "sfOF")
#'
#' @export
getBound <- function(k = NA_integer_, informationRates = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, spendingTime = NA_real_) {
    .Call(`_lrstat_getBound`, k, informationRates, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, spendingTime)
}

#' @title Repeated p-values for group sequential design
#' @description Obtains the repeated p-values for a group sequential design.
#'
#' @param k Look number for the current analysis.
#' @param informationRates Information rates up to the current look, must be
#'   increasing and less than or equal to 1.
#' @param p The raw p-values at look 1 to look \code{k}. 
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @param spendingTime A vector of length \code{k} for the error spending  
#'   time at each analysis, must be increasing and less than or equal to 1. 
#'   Defaults to missing, in which case, it is the same as 
#'   \code{informationRates}.
#'
#' @return The repeated p-values at look 1 to look \code{k}.
#'
#' @examples
#'
#' repeatedPValue(k = 3, informationRates = c(529, 700, 800)/800,
#'                p = c(0.2, 0.15, 0.1), typeAlphaSpending = "sfOF",
#'                spendingTime = c(0.6271186, 0.8305085, 1))
#'
#' @export
repeatedPValue <- function(k = NA_integer_, informationRates = NA_real_, p = NA_real_, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, spendingTime = NA_real_) {
    .Call(`_lrstat_repeatedPValue`, k, informationRates, p, typeAlphaSpending, parameterAlphaSpending, spendingTime)
}

#' @title Group sequential trials using Bonferroni-based graphical 
#' approaches
#' 
#' @description Obtains the test results for group sequential trials using 
#' graphical approaches based on weighted Bonferroni tests.
#'
#' @param w The vector of initial weights for elementary hypotheses.
#' @param G The initial transition matrix.
#' @param alpha The significance level. Defaults to 0.025.
#' @param typeAlphaSpending The vector of alpha spending functions. 
#'   Each element is one of the following: 
#'   "OF" for O'Brien-Fleming boundaries, 
#'   "P" for Pocock boundaries, "WT" for Wang & Tsiatis boundaries, 
#'   "sfOF" for O'Brien-Fleming type spending function, 
#'   "sfP" for Pocock type spending function,
#'   "sfKD" for Kim & DeMets spending function, 
#'   "sfHSD" for Hwang, Shi & DeCani spending function, 
#'   and "none" for no early efficacy stopping.
#' @param parameterAlphaSpending The vector of parameter values for the 
#'   alpha spending functions. Each element corresponds to the value of 
#'   Delta for "WT", rho for "sfKD", or gamma for "sfHSD".
#' @param incidenceMatrix The incidence matrix indicating whether the 
#'   specific hypothesis will be tested at the given look.
#' @param maxInformation The vector of targeted maximum information for each 
#'   hypothesis.
#' @param information The matrix of observed information for each hypothesis 
#'   by look.
#' @param p The matrix of raw p-values for each hypothesis by look. 
#' @param spendingTime The spending time for alpha spending. Defaults to 
#'   missing, in which case, it is the same as \code{informationRates} 
#'   calculated from \code{information} and \code{maxInformation}.
#' @param repeatedPValueFlag Flag for whether to report the repeated 
#'   p-values. Defaults to FALSE.
#' 
#' @return A list with a component vector to indicate the first look the 
#'   specific hypothesis rejected (0 if the hypothesis is not rejected) and,  
#'   if \code{reppfl = 1}, a component matrix for the repeated p-values for 
#'   each hypothesis over time. 
#'
#' @references
#' Willi Maurer and Frank Bretz. Multiple testing in group sequential
#' trials using graphical approaches. Statistics in Biopharmaceutical 
#' Research. 2013;5:311-320. \doi{10.1080/19466315.2013.807748}
#'
#' @examples
#' 
#' # Case study from Maurer & Bretz (2013) 
#' 
#' fseqbon(
#'   w = c(0.5, 0.5, 0, 0),
#'   G = matrix(c(0, 0.5, 0.5, 0,  0.5, 0, 0, 0.5,  
#'                0, 1, 0, 0,  1, 0, 0, 0), 
#'              nrow=4, ncol=4, byrow=TRUE),
#'   alpha = 0.025,
#'   typeAlphaSpending = rep("sfOF", 4),
#'   incidenceMatrix = matrix(1, nrow=4, ncol=3),
#'   maxInformation = rep(1,4),
#'   information = matrix(c(rep(1/3, 4), rep(2/3, 4)), nrow=4, ncol=2),
#'   p = matrix(c(0.0062, 0.017, 0.009, 0.13, 
#'                0.0002, 0.0035, 0.002, 0.06), 
#'              nrow=4, ncol=2),
#'   repeatedPValueFlag = 1)
#' 
#'
#' @export
fseqbon <- function(w, G, alpha = 0.025, typeAlphaSpending = NA_character_, parameterAlphaSpending = NA_real_, incidenceMatrix = NA_integer_, maxInformation = NA_real_, information = NA_real_, p = NA_real_, spendingTime = matrix(0,1,1), repeatedPValueFlag = 0L) {
    .Call(`_lrstat_fseqbon`, w, G, alpha, typeAlphaSpending, parameterAlphaSpending, incidenceMatrix, maxInformation, information, p, spendingTime, repeatedPValueFlag)
}

#' @title Log-rank test simulation
#' @description Performs simulation for two-arm group sequential
#' trials based on weighted log-rank test.
#'
#' @inheritParams param_kMax
#' @param informationTime Information time in terms of variance of
#'   weighted log-rank test score statistic under the null hypothesis.
#'   Same as informationRates in terms of number of events for
#'   the conventional log-rank test. Use \code{caltime} and \code{lrstat}
#'   to derive the information time for weighted log-rank tests.
#'   Fixed prior to the trial. If left unspecified, it defaults to
#'   \code{plannedEvents / plannedEvents[kMax]} when \code{plannedEvents} 
#'   is provided and to \code{plannedTime / plannedTime[kMax]} otherwise.
#' @inheritParams param_criticalValues
#' @inheritParams param_futilityBounds
#' @inheritParams param_hazardRatioH0
#' @param allocation1 Number of subjects in the active treatment group in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation2 Number of subjects in the control group in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @param plannedEvents The planned cumulative total number of events at each
#'   stage.
#' @param plannedTime The planned analysis time for each stage needed for  
#'   analyses planned at calendar times, in which case, \code{plannedEvents}
#'   should be missing.
#' @param maxNumberOfIterations The number of simulation iterations.
#'   Defaults to 1000.
#' @param maxNumberOfRawDatasetsPerStage The number of raw datasets per stage
#'   to extract. Defaults to 1.
#' @param seed The seed to reproduce the simulation results.
#'   The computer clock will be used if left unspecified,
#'
#' @return A list of S3 class \code{lrsim} with 3 components:
#'
#' * \code{overview} is a list of containing incremental and cumulative
#' efficacy and futility stopping probabilities by stage, expected number
#' of events, number of dropouts, number of subjects, and analysis time
#' by stage, overall rejection probability, overall expected number of
#' events, number of dropouts, number of subjects, and study duration,
#' the hazard ratio under H0, and whether the analyses are planned 
#' based on the number of events or calendar time.
#'
#' * \code{sumdata} is a data frame of summary data by stage for each
#' iteration, containing at which stage the trial stops, whether the target
#' number of events is achieved, the analysis time, number of accrued
#' subjects overall and by treatment group, number of events overall and by
#' treatment group, number of dropouts overall and by treatment group,
#' numerator and variance of weighted log-rank score statistic, log-rank
#' test Z-statistic, and whether the trial stops for efficacy or futility
#' at the stage.
#'
#'
#' * \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
#' positive integer) is a data frame for subject-level data for selected
#' replications, containing the subject number, arrival time, stratum,
#' treatment group, survival time, dropout time, observation time when
#' the trial stops, time under observation, and event and dropout
#' indicators.
#'
#' @examples
#' # Example 1: analyses based on number of events
#' 
#' sim1 = lrsim(kMax = 2, informationTime = c(0.5, 1),
#'              criticalValues = c(2.797, 1.977),
#'              accrualIntensity = 11,
#'              lambda1 = 0.018, lambda2 = 0.030,
#'              accrualDuration = 12,
#'              plannedEvents = c(60, 120),
#'              maxNumberOfIterations = 1000,
#'              maxNumberOfRawDatasetsPerStage = 1,
#'              seed = 314159)
#'
#' # summary statistics
#' sim1
#'
#' # summary for each simulated data set
#' head(sim1$sumdata)
#'
#' # raw data for selected replication
#' head(sim1$rawdata)
#'
#'
#' # Example 2: analyses based on calendar time have similar power
#'
#' sim2 = lrsim(kMax = 2, informationTime = c(0.5, 1),
#'              criticalValues = c(2.797, 1.977),
#'              accrualIntensity = 11,
#'              lambda1 = 0.018, lambda2 = 0.030,
#'              accrualDuration = 12,
#'              plannedTime = c(31.9, 113.2),
#'              maxNumberOfIterations = 1000,
#'              maxNumberOfRawDatasetsPerStage = 1,
#'              seed = 314159)
#'
#' # summary statistics
#' sim2
#'
#' # summary for each simulated data set
#' head(sim2$sumdata)
#' 
#' @export
lrsim <- function(kMax = NA_integer_, informationTime = NA_real_, criticalValues = NA_real_, futilityBounds = NA_real_, hazardRatioH0 = 1, allocation1 = 1L, allocation2 = 1L, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, plannedEvents = NA_integer_, plannedTime = NA_real_, maxNumberOfIterations = 1000L, maxNumberOfRawDatasetsPerStage = 0L, seed = NA_integer_) {
    .Call(`_lrstat_lrsim`, kMax, informationTime, criticalValues, futilityBounds, hazardRatioH0, allocation1, allocation2, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, plannedEvents, plannedTime, maxNumberOfIterations, maxNumberOfRawDatasetsPerStage, seed)
}

#' @title Log-rank test simulation for three arms
#' @description Performs simulation for three-arm group 
#' sequential trials based on weighted log-rank test. The  
#' looks are driven by the total number of events in Arm A 
#' and Arm C combined. 
#' 
#' @inheritParams param_kMax
#' @param hazardRatioH013 Hazard ratio under the null hypothesis for arm 1
#'   versus arm 3. Defaults to 1 for superiority test.
#' @param hazardRatioH023 Hazard ratio under the null hypothesis for arm 2
#'   versus arm 3. Defaults to 1 for superiority test.
#' @param hazardRatioH012 Hazard ratio under the null hypothesis for arm 1
#'   versus arm 2. Defaults to 1 for superiority test.
#' @param allocation1 Number of subjects in Arm A in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation2 Number of subjects in Arm B in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation3 Number of subjects in Arm C in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @param lambda1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 1.
#' @param lambda2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 2.
#' @param lambda3 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 3.
#' @param gamma1 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 1.
#' @param gamma2 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 2.
#' @param gamma3 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 3.
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @param plannedEvents The planned cumulative total number of events at 
#'   Look 1 to Look \code{kMax} for Arms A and C combined.
#' @param plannedTime The planned analysis time for each stage needed for  
#'   analyses planned at calendar times, in which case, \code{plannedEvents} 
#'   should be missing.
#' @param maxNumberOfIterations The number of simulation iterations.
#'   Defaults to 1000.
#' @param maxNumberOfRawDatasetsPerStage The number of raw datasets per stage
#'   to extract. Defaults to 1.
#' @param seed The seed to reproduce the simulation results.
#'   The computer clock will be used if left unspecified,
#'
#' @return A list with 2 components:
#'
#' * \code{sumdata} is a data frame of summary data by stage for each
#' iteration, containing the analysis time, number of accrued subjects 
#' overall and by treatment group, and number of events overall and 
#' by treatment group, number of dropouts overall and by treatment group, 
#' and log-rank test statistic for each comparison.
#'
#' * \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
#' positive integer) is a data frame for subject-level data for selected
#' replications, containing the stage number, subject number, arrival time, 
#' stratum, treatment group, observation time, and survival time, 
#' dropout time, time under observation, event and dropout indicators.
#' 
#' @examples
#' 
#' sim1 = lrsim3a(
#'   kMax = 3, 
#'   allocation1 = 2, 
#'   allocation2 = 2, 
#'   allocation3 = 1,
#'   accrualTime = c(0, 8), 
#'   accrualIntensity = c(10, 28),
#'   piecewiseSurvivalTime = 0, 
#'   lambda1 = log(2)/12*0.60,
#'   lambda2 = log(2)/12*0.70,
#'   lambda3 = log(2)/12,
#'   accrualDuration = 30.143,
#'   plannedEvents = c(186, 259, 295),
#'   maxNumberOfIterations = 1000,
#'   maxNumberOfRawDatasetsPerStage = 1,
#'   seed = 314159)
#'   
#' head(sim1$sumdata)
#' head(sim1$rawdata)
#' 
#' @export
lrsim3a <- function(kMax = NA_integer_, hazardRatioH013 = 1, hazardRatioH023 = 1, hazardRatioH012 = 1, allocation1 = 1L, allocation2 = 1L, allocation3 = 1L, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, lambda3 = NA_real_, gamma1 = 0L, gamma2 = 0L, gamma3 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, plannedEvents = NA_integer_, plannedTime = NA_real_, maxNumberOfIterations = 1000L, maxNumberOfRawDatasetsPerStage = 0L, seed = NA_integer_) {
    .Call(`_lrstat_lrsim3a`, kMax, hazardRatioH013, hazardRatioH023, hazardRatioH012, allocation1, allocation2, allocation3, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, lambda3, gamma1, gamma2, gamma3, accrualDuration, followupTime, fixedFollowup, rho1, rho2, plannedEvents, plannedTime, maxNumberOfIterations, maxNumberOfRawDatasetsPerStage, seed)
}

#' @title Log-rank test simulation for two endpoints and two arms
#' @description Performs simulation for two-endpoint two-arm group 
#' sequential trials based on weighted log-rank test. The first \code{kMaxe1} 
#' looks are driven by the total number of PFS events in two arms 
#' combined, and the subsequent looks are driven by the total 
#' number of OS events in two arms combined. 
#' 
#' @inheritParams param_kMax
#' @param kMaxe1 Number of stages with timing determined by PFS events. 
#'   Ranges from 0 (none) to \code{kMax}. 
#' @param hazardRatioH0e1 Hazard ratio under the null hypothesis for the 
#'   active treatment vs control for endpoint 1 (PFS). Defaults to 1 for 
#'   superiority test.
#' @param hazardRatioH0e2 Hazard ratio under the null hypothesis for the 
#'   active treatment vs control for endpoint 2 (OS). Defaults to 1 for 
#'   superiority test.
#' @param allocation1 Number of subjects in the treatment group in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation2 Number of subjects in the control group in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @param rho The correlation coefficient for the standard bivariate normal
#'   random variables used to generate time to disease progression and time 
#'   to death using the inverse CDF method.
#' @param lambda1e1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for the treatment group and endpoint 1 (PFS).
#' @param lambda2e1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for the control group and endpoint 1 (PFS).
#' @param lambda1e2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for the treatment group and endpoint 2 (OS).
#' @param lambda2e2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for the control group and endpoint 2 (OS).
#' @param gamma1e1 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for the treatment group and endpoint 1 (PFS).
#' @param gamma2e1 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for the control group and endpoint 1 (PFS).
#' @param gamma1e2 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for the treatment group and endpoint 2 (OS).
#' @param gamma2e2 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for the control group and endpoint 2 (OS).
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @param plannedEvents The planned cumulative total number of PFS events at 
#'   Look 1 to Look kMaxe1 and the planned cumulative total number of OS 
#'   events at Look kMaxe1+1 to Look kMax.
#' @param plannedTime The planned analysis time for each stage needed for  
#'   analyses planned at calendar times, in which case, \code{plannedEvents} 
#'   should be missing.
#' @param maxNumberOfIterations The number of simulation iterations.
#'   Defaults to 1000.
#' @param maxNumberOfRawDatasetsPerStage The number of raw datasets per stage
#'   to extract. Defaults to 1.
#' @param seed The seed to reproduce the simulation results.
#'   The computer clock will be used if left unspecified,
#'
#' @return A list with 2 components:
#'
#' * \code{sumdata} is a data frame of summary data by stage for each
#' iteration, containing the analysis time, number of accrued subjects 
#' overall and by treatment group, and number of events overall and 
#' by treatment group, number of dropouts overall and by treatment group, 
#' and log-rank test statistic by endpoint.
#'
#' * \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
#' positive integer) is a data frame for subject-level data for selected
#' replications, containing the stage number, subject number, arrival time, 
#' stratum, treatment group, observation time, and survival time, 
#' dropout time, time under observation, event and dropout indicators 
#' for each endpoint.
#' 
#' @examples
#' 
#' sim1 = lrsim2e(
#'   kMax = 3, 
#'   kMaxe1 = 2,
#'   allocation1 = 2, 
#'   allocation2 = 1, 
#'   accrualTime = c(0, 8), 
#'   accrualIntensity = c(10, 28),
#'   piecewiseSurvivalTime = 0, 
#'   rho = 0,
#'   lambda1e1 = log(2)/12*0.60,
#'   lambda2e1 = log(2)/12,
#'   lambda1e2 = log(2)/30*0.65, 
#'   lambda2e2 = log(2)/30,
#'   accrualDuration = 20.143,
#'   plannedEvents = c(186, 259, 183),
#'   maxNumberOfIterations = 1000,
#'   maxNumberOfRawDatasetsPerStage = 1,
#'   seed = 314159)
#'  
#' head(sim1$sumdata)
#' head(sim1$rawdata)
#' 
#' @export
lrsim2e <- function(kMax = NA_integer_, kMaxe1 = NA_integer_, hazardRatioH0e1 = 1, hazardRatioH0e2 = 1, allocation1 = 1L, allocation2 = 1L, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, rho = 0, lambda1e1 = NA_real_, lambda2e1 = NA_real_, lambda1e2 = NA_real_, lambda2e2 = NA_real_, gamma1e1 = 0L, gamma2e1 = 0L, gamma1e2 = 0L, gamma2e2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, plannedEvents = NA_integer_, plannedTime = NA_real_, maxNumberOfIterations = 1000L, maxNumberOfRawDatasetsPerStage = 0L, seed = NA_integer_) {
    .Call(`_lrstat_lrsim2e`, kMax, kMaxe1, hazardRatioH0e1, hazardRatioH0e2, allocation1, allocation2, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, rho, lambda1e1, lambda2e1, lambda1e2, lambda2e2, gamma1e1, gamma2e1, gamma1e2, gamma2e2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, plannedEvents, plannedTime, maxNumberOfIterations, maxNumberOfRawDatasetsPerStage, seed)
}

#' @title Log-rank test simulation for two endpoints and three arms
#' @description Performs simulation for two-endpoint three-arm group 
#' sequential trials based on weighted log-rank test. The first \code{kMaxe1} 
#' looks are driven by the total number of PFS events in Arm A 
#' and Arm C combined, and the subsequent looks are driven by the total 
#' number of OS events in Arm A and Arm C combined. 
#' 
#' @inheritParams param_kMax
#' @param kMaxe1 Number of stages with timing determined by PFS events. 
#'   Ranges from 0 (none) to \code{kMax}. 
#' @param hazardRatioH013e1 Hazard ratio under the null hypothesis for arm 1 
#'   vs arm 3 for endpoint 1 (PFS). Defaults to 1 for superiority test.
#' @param hazardRatioH023e1 Hazard ratio under the null hypothesis for arm 2 
#'   vs arm 3 for endpoint 1 (PFS). Defaults to 1 for superiority test.
#' @param hazardRatioH012e1 Hazard ratio under the null hypothesis for arm 1 
#'   vs arm 2 for endpoint 1 (PFS). Defaults to 1 for superiority test.
#' @param hazardRatioH013e2 Hazard ratio under the null hypothesis for arm 1 
#'   vs arm 3 for endpoint 2 (OS). Defaults to 1 for superiority test.
#' @param hazardRatioH023e2 Hazard ratio under the null hypothesis for arm 2 
#'   vs arm 3 for endpoint 2 (OS). Defaults to 1 for superiority test.
#' @param hazardRatioH012e2 Hazard ratio under the null hypothesis for arm 1 
#'   vs arm 2 for endpoint 2 (OS). Defaults to 1 for superiority test.
#' @param allocation1 Number of subjects in Arm A in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation2 Number of subjects in Arm B in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @param allocation3 Number of subjects in Arm C in
#'   a randomization block. Defaults to 1 for equal randomization.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @param rho The correlation coefficient for the standard bivariate normal
#'   random variables used to generate time to disease progression and time 
#'   to death using the inverse CDF method.
#' @param lambda1e1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 1 and endpoint 1 (PFS).
#' @param lambda2e1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 2 and endpoint 1 (PFS).
#' @param lambda3e1 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 3 and endpoint 1 (PFS).
#' @param lambda1e2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 1 and endpoint 2 (OS).
#' @param lambda2e2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 2 and endpoint 2 (OS).
#' @param lambda3e2 A vector of hazard rates for the event in each analysis  
#'   time interval by stratum for arm 3 and endpoint 2 (OS).
#' @param gamma1e1 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 1 and endpoint 1 (PFS).
#' @param gamma2e1 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 2 and endpoint 1 (PFS).
#' @param gamma3e1 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 3 and endpoint 1 (PFS).
#' @param gamma1e2 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 1 and endpoint 2 (OS).
#' @param gamma2e2 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 2 and endpoint 2 (OS).
#' @param gamma3e2 The hazard rate for exponential dropout, a vector of 
#'   hazard rates for piecewise exponential dropout applicable for all 
#'   strata, or a vector of hazard rates for dropout in each analysis time 
#'   interval by stratum for arm 3 and endpoint 2 (OS).
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @param plannedEvents The planned cumulative total number of PFS events at 
#'   Look 1 to Look kMaxe1 for Arms A and C combined and the planned 
#'   cumulative total number of OS events at Look kMaxe1+1 to Look kMax 
#'   for Arms A and C combined.
#' @param plannedTime The planned analysis time for each stage needed for  
#'   analyses planned at calendar times, in which case, \code{plannedEvents} 
#'   should be missing.
#' @param maxNumberOfIterations The number of simulation iterations.
#'   Defaults to 1000.
#' @param maxNumberOfRawDatasetsPerStage The number of raw datasets per stage
#'   to extract. Defaults to 1.
#' @param seed The seed to reproduce the simulation results.
#'   The computer clock will be used if left unspecified,
#'
#' @return A list with 2 components:
#'
#' * \code{sumdata} is a data frame of summary data by stage for each
#' iteration, containing the analysis time, number of accrued subjects 
#' overall and by treatment group, and number of events overall and 
#' by treatment group, number of dropouts overall and by treatment group, 
#' and log-rank test statistic for each comparison by endpoint.
#'
#' * \code{rawdata} (exists if \code{maxNumberOfRawDatasetsPerStage} is a
#' positive integer) is a data frame for subject-level data for selected
#' replications, containing the stage number, subject number, arrival time, 
#' stratum, treatment group, observation time, and survival time, 
#' dropout time, time under observation, event and dropout indicators 
#' for each endpoint.
#' 
#' @examples
#' 
#' sim1 = lrsim2e3a(
#'   kMax = 3, 
#'   kMaxe1 = 2,
#'   allocation1 = 2, 
#'   allocation2 = 2, 
#'   allocation3 = 1,
#'   accrualTime = c(0, 8), 
#'   accrualIntensity = c(10, 28),
#'   piecewiseSurvivalTime = 0, 
#'   rho = 0,
#'   lambda1e1 = log(2)/12*0.60,
#'   lambda2e1 = log(2)/12*0.70,
#'   lambda3e1 = log(2)/12,
#'   lambda1e2 = log(2)/30*0.65, 
#'   lambda2e2 = log(2)/30*0.75,
#'   lambda3e2 = log(2)/30,
#'   accrualDuration = 30.143,
#'   plannedEvents = c(186, 259, 183),
#'   maxNumberOfIterations = 1000,
#'   maxNumberOfRawDatasetsPerStage = 1,
#'   seed = 314159)
#'  
#' head(sim1$sumdata)
#' head(sim1$rawdata)
#'  
#' @export
lrsim2e3a <- function(kMax = NA_integer_, kMaxe1 = NA_integer_, hazardRatioH013e1 = 1, hazardRatioH023e1 = 1, hazardRatioH012e1 = 1, hazardRatioH013e2 = 1, hazardRatioH023e2 = 1, hazardRatioH012e2 = 1, allocation1 = 1L, allocation2 = 1L, allocation3 = 1L, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, rho = 0, lambda1e1 = NA_real_, lambda2e1 = NA_real_, lambda3e1 = NA_real_, lambda1e2 = NA_real_, lambda2e2 = NA_real_, lambda3e2 = NA_real_, gamma1e1 = 0L, gamma2e1 = 0L, gamma3e1 = 0L, gamma1e2 = 0L, gamma2e2 = 0L, gamma3e2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, plannedEvents = NA_integer_, plannedTime = NA_real_, maxNumberOfIterations = 1000L, maxNumberOfRawDatasetsPerStage = 0L, seed = NA_integer_) {
    .Call(`_lrstat_lrsim2e3a`, kMax, kMaxe1, hazardRatioH013e1, hazardRatioH023e1, hazardRatioH012e1, hazardRatioH013e2, hazardRatioH023e2, hazardRatioH012e2, allocation1, allocation2, allocation3, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, rho, lambda1e1, lambda2e1, lambda3e1, lambda1e2, lambda2e2, lambda3e2, gamma1e1, gamma2e1, gamma3e1, gamma1e2, gamma2e2, gamma3e2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, plannedEvents, plannedTime, maxNumberOfIterations, maxNumberOfRawDatasetsPerStage, seed)
}

#' @title Number of enrolled subjects
#' @description Obtains the number of subjects enrolled by given calendar
#' times.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of enrolled subjects.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_accrualDuration
#'
#' @return A vector of total number of subjects enrolled by the
#' specified calendar times.
#'
#' @examples
#' # Example 1: Uniform enrollment with 20 patients per month for 12 months.
#'
#' accrual(time = 3, accrualTime = 0, accrualIntensity = 20,
#'         accrualDuration = 12)
#'
#'
#' # Example 2: Piecewise accrual, 10 patients per month for the first
#' # 3 months, and 20 patients per month thereafter. Patient recruitment
#' # ends at 12 months for the study.
#'
#' accrual(time = c(2, 9), accrualTime = c(0, 3),
#'         accrualIntensity = c(10, 20), accrualDuration = 12)
#'
#' @export
accrual <- function(time = NA_real_, accrualTime = 0L, accrualIntensity = NA_real_, accrualDuration = NA_real_) {
    .Call(`_lrstat_accrual`, time, accrualTime, accrualIntensity, accrualDuration)
}

#' @title Probability of being at risk
#' @description Obtains the probability of being at risk at given analysis
#' times.
#'
#' @param time A vector of analysis times at which to calculate the
#' probability of being at risk.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of probabilities of being at risk at the specified
#' analysis times after enrollment for a patient in a treatment group with
#' specified piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#' 
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' patrisk(time = c(3, 9), piecewiseSurvivalTime = c(0, 6),
#'         lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
patrisk <- function(time = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_patrisk`, time, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Probability of having an event
#' @description Obtains the probability of having an event at given analysis
#' times.
#'
#' @param time A vector of analysis times at which to calculate the
#' probability of having an event.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of probabilities of having an event at the specified
#' analysis times after enrollment for a patient in a treatment group with
#' specified piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' pevent(time = c(3, 9), piecewiseSurvivalTime = c(0, 6),
#'        lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
pevent <- function(time = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_pevent`, time, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Integrated event probability over an interval with constant hazard
#' @description Obtains the integration probability of having an event
#' during an interval with constant hazard.
#'
#' @param j The analysis time interval with constant hazard.
#' @param t1 Lower bound of the analysis time interval.
#' @param t2 Upper bound of the analysis time interval.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A value for the integrated probability of having an event
#' during an interval with constant hazard for a treatment
#' group with specified piecewise exponential survival and dropout
#' distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' hd(j = 1, t1 = 1, t2 = 3, piecewiseSurvivalTime = c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
hd <- function(j = NA_integer_, t1 = NA_real_, t2 = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_hd`, j, t1, t2, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Integrated event probability over an interval
#' @description Obtains the integration of the probability of having an event
#' during an interval. The specified analysis time interval can span more
#' than one analysis time interval with constant hazard.
#'
#' @param t1 Lower bound of the analysis time interval.
#' @param t2 Upper bound of the analysis time interval.
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A value for the integrated probability of having an event
#' during an interval for a treatment group with specified
#' piecewise exponential survival and dropout distributions.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise exponential survival with hazard 0.0533 in the first 6 months,
#' # and hazard 0.0309 thereafter, and 5% dropout by the end of 1 year.
#'
#' pd(t1 = 1, t2 = 8, piecewiseSurvivalTime = c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
pd <- function(t1 = NA_real_, t2 = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_pd`, t1, t2, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Number of patients enrolled during an interval and having an event
#' by specified calendar times
#' @description Obtains the number of patients who are enrolled during a
#' specified enrollment time interval and have an event by the specified
#' calendar times.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of patients having an event.
#' @param u1 Lower bound of the accrual time interval.
#' @param u2 Upper bound of the accrual time interval.
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda
#' @inheritParams param_gamma
#'
#' @return A vector of number of patients who are enrolled during a
#' specified enrollment time interval and have an event by the specified
#' calendar times for a given treatment group had the enrollment being
#' restricted to the treatment group. By definition, we must have
#' \code{time >= u2}.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, 10 patients per month for the first 3 months, and
#' # 20 patients per month thereafter. Piecewise exponential survival with
#' # hazard 0.0533 in the first 6 months, and hazard 0.0309 thereafter,
#' # and 5% dropout by the end of 1 year.
#'
#' ad(time = c(9, 15), u1 = 1, u2 = 8, accrualTime = c(0, 3),
#'    accrualIntensity = c(10, 20), piecewiseSurvivalTime=c(0, 6),
#'    lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)
#'
#' @export
ad <- function(time = NA_real_, u1 = NA_real_, u2 = NA_real_, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda = NA_real_, gamma = 0L) {
    .Call(`_lrstat_ad`, time, u1, u2, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda, gamma)
}

#' @title Number of subjects at risk
#' @description Obtains the number of subjects at risk at given analysis
#' times for each treatment group.
#'
#' @param time A vector of analysis times at which to calculate the number
#' of patients at risk.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients at risk at the specified
#' analysis times (row) for each treatment group (column).
#'
#' @keywords internal
#' 
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' natrisk(time = c(9, 24), allocationRatioPlanned = 1,
#'         accrualTime = c(0, 3), accrualIntensity = c(10, 20),
#'         piecewiseSurvivalTime = c(0, 6),
#'         lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'         gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 12, minFollowupTime = 18,
#'         maxFollowupTime = 30)
#'
#' @export
natrisk <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_natrisk`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event
#' @description Obtains the number of subjects having an event by given
#' analysis times for each treatment group.
#'
#' @param time A vector of analysis times at which to calculate the number
#' of patients having an event.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients having an event at the specified
#' analysis times (row) for each treatment group (column).
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' nevent(time = c(9, 24), allocationRatioPlanned = 1,
#'        accrualTime = c(0, 3), accrualIntensity = c(10, 20),
#'        piecewiseSurvivalTime = c(0, 6),
#'        lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'        gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'        accrualDuration = 12, minFollowupTime = 18,
#'        maxFollowupTime = 30)
#'
#' @export
nevent <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_nevent`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event by calendar time
#' @description Obtains the number of subjects having an event by given
#' calendar times for each treatment group.
#'
#' @param time A vector of calendar times at which to calculate the number
#' of patients having an event.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_lambda1
#' @inheritParams param_lambda2
#' @inheritParams param_gamma1
#' @inheritParams param_gamma2
#' @inheritParams param_accrualDuration
#' @inheritParams param_minFollowupTime
#' @inheritParams param_maxFollowupTime
#'
#' @return A matrix of the number of patients having an event at the specified
#' calendar times (row) for each treatment group (column).
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#' nevent2(time = c(9, 24), allocationRatioPlanned = 1,
#'         accrualTime = c(0, 3), accrualIntensity = c(10, 20),
#'         piecewiseSurvivalTime = c(0, 6),
#'         lambda1 = c(0.0533, 0.0309), lambda2 = c(0.0533, 0.0533),
#'         gamma1 = -log(1-0.05)/12, gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 12, minFollowupTime = 18,
#'         maxFollowupTime = 30)
#'
#' @export
nevent2 <- function(time = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, minFollowupTime = NA_real_, maxFollowupTime = NA_real_) {
    .Call(`_lrstat_nevent2`, time, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, lambda1, lambda2, gamma1, gamma2, accrualDuration, minFollowupTime, maxFollowupTime)
}

#' @title Number of subjects having an event and log-rank statistic
#' for a hypothesized hazard ratio at a given calendar time
#'
#' @description Obtains the number of subjects having an event in each
#' treatment group by stratum, the mean and variance of weighted log-rank
#' score statistic for a hypothesized hazard ratio at a given calendar time.
#'
#' @param time The calendar time at which to calculate the number
#'  of events and the mean and variance of log-rank test score statistic.
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @param predictEventOnly Whether to predict the number of events only.
#'  Defaults to 0 for obtaining log-rank test score statistic mean
#'  and variance.
#'
#' @return A data frame of the number of subjects enrolled, the number of
#' subjects having an event overall and in each group, the number of
#' subjects who drop out overall and in each group, the mean and
#' variance of weighted log-rank score statistic at the specified
#' calendar time by stratum.
#'
#' @keywords internal
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' lrstat1(time = 22, hazardRatioH0 = 1,
#'         allocationRatioPlanned = 1,
#'         accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrstat1 <- function(time = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, predictEventOnly = 0L) {
    .Call(`_lrstat_lrstat1`, time, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, predictEventOnly)
}

#' @title Number of subjects having an event and log-rank statistics
#' @description Obtains the number of subjects accrued, number of events and
#' number of dropouts in each group, mean and variance of weighted log-rank
#' score statistic, estimated hazard ratio from weighted Cox regression
#' and variance of log hazard ratio estimate at given calendar times.
#'
#' @param time A vector of calendar times at which to calculate the number
#'  of events and the mean and variance of log-rank test score statistic.
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @param predictEventOnly Whether to predict the number of events only.
#' Defaults to 0 for obtaining log-rank score statistic mean and variance.
#' Set \code{predictEventOnly = 1} for predicting the number of events only.
#' Set \code{predictEventOnly = 2} for predicting the number of events,
#' calculating the mean and variance of log-rank score statistic, and
#' calculating the estimated hazard ratio and variance of log hazard ratio.
#'
#' @return A data frame of the number of subjects enrolled, the number of
#' subjects having an event overall and in each group, the number of subjects
#' who drop out overall and in each group, the mean and variance of weighted
#' log-rank score statistic, the estimated hazard ratio from weighted Cox
#' regression, and variance of the log hazard ratio estimate at the
#' specified calendar times.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' lrstat(time = c(22, 40), allocationRatioPlanned = 1,
#'        accrualTime = seq(0, 9),
#'        accrualIntensity = c(26/9*seq(1, 9), 26),
#'        piecewiseSurvivalTime = c(0, 6),
#'        stratumFraction = c(0.2, 0.8),
#'        lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'        lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'        gamma1 = -log(1-0.05)/12,
#'        gamma2 = -log(1-0.05)/12,
#'        accrualDuration = 22,
#'        followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrstat <- function(time = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, predictEventOnly = 0L) {
    .Call(`_lrstat_lrstat`, time, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, predictEventOnly)
}

#' @title Calendar times for target number of events
#' @description Obtains the calendar times to reach the target number of
#' subjects having an event.
#'
#' @param nevents A vector of target number of events.
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_numSubintervals
#'
#' @return A vector of calendar times expected to yield the target
#' number of events.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' caltime(nevents = c(24, 80), allocationRatioPlanned = 1,
#'         accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12,
#'         accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
caltime <- function(nevents = NA_real_, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = NA_real_, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = NA_real_, lambda2 = NA_real_, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = NA_real_, fixedFollowup = 0L, numSubintervals = 300L) {
    .Call(`_lrstat_caltime`, nevents, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, numSubintervals)
}

getCriticalValues <- function(kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = 20L, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda2 = 0.0533, gamma1 = 0L, gamma2 = 0L, accrualDuration = 11.6, followupTime = 18, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, spendingTime = NA_real_) {
    .Call(`_lrstat_getCriticalValues`, kMax, informationRates, efficacyStopping, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, spendingTime)
}

getCumAlphaSpent <- function(kMax = NA_integer_, informationRates = NA_real_, criticalValues = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = 20L, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda2 = 0.0533, gamma1 = 0L, gamma2 = 0L, accrualDuration = 11.6, followupTime = 18, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L) {
    .Call(`_lrstat_getCumAlphaSpent`, kMax, informationRates, criticalValues, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals)
}

#' @title Log-rank test power
#' @description Estimates the power, stopping probabilities, and expected
#' sample size in a two-group survival design.
#'
#' @inheritParams param_kMax
#' @inheritParams param_informationRates
#' @inheritParams param_efficacyStopping
#' @inheritParams param_futilityStopping
#' @inheritParams param_criticalValues
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @inheritParams param_futilityBounds
#' @param typeBetaSpending The type of beta spending. One of the following:
#'  "sfOF" for O'Brien-Fleming type spending function, "sfP" for Pocock type
#'  spending function, "sfKD" for Kim & DeMets spending function,
#'  "sfHSD" for Hwang, Shi & DeCani spending function, and "none" for no
#'  early futility stopping. Defaults to "none".
#' @inheritParams param_parameterBetaSpending
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @inheritParams param_estimateHazardRatio
#' @inheritParams param_typeOfComputation
#' @param spendingTime A vector of length \code{kMax} for the error spending 
#'   time at each analysis. Defaults to missing, in which case, it is the 
#'   same as \code{informationRates}.
#'   
#' @return A list of S3 class \code{lrpower} with 3 components:
#'
#' * \code{overallResults} containing the overall rejection probability,
#' overall significance level, maximum and expected number of events,
#' maximum and expected number of dropouts, total and expected number
#' of subjects, maximum and expected study duration, along with
#' input parameters including accrual duration, followup duration,
#' whether a fixed follow-up is used, parameters for the FH weights,
#' allocation ratio, number of stages, and hazard ratio under H0.
#'
#' * \code{byStageResults} containing information rates, efficacy
#' and futility boundaries on the Z-scale, probability for efficacy
#' and futility stopping at the stage, cumulative probability for
#' efficacy and futility stopping by the stage, cumulative alpha spent,
#' expected number of events, number of dropouts, number of subjects,
#' and expected study time, efficacy and futility boundaries on
#' the HR scale and on the p-value scale, information for weighted
#' log-rank test, hazard ratio from weighted Cox regression, and
#' where efficacy and futility stopping are allowed by stage.
#'
#' * \code{settings} containing input parameters such as
#' alpha and beta spending function and parameter values,
#' accrual time, accrual intensity, piecewise survival time, stratum
#' fraction, and hazard rates for survival and dropout by group.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' lrpower(kMax = 2, informationRates = c(0.8, 1),
#'         alpha = 0.025, typeAlphaSpending = "sfOF",
#'         allocationRatioPlanned = 1, accrualTime = seq(0, 9),
#'         accrualIntensity = c(26/9*seq(1, 9), 26),
#'         piecewiseSurvivalTime = c(0, 6),
#'         stratumFraction = c(0.2, 0.8),
#'         lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'         lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'         gamma1 = -log(1-0.05)/12,
#'         gamma2 = -log(1-0.05)/12, accrualDuration = 22,
#'         followupTime = 18, fixedFollowup = FALSE)
#'
#' @export
lrpower <- function(kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = 20L, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = 0.0309, lambda2 = 0.0533, gamma1 = 0L, gamma2 = 0L, accrualDuration = 11.6, followupTime = 18, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, estimateHazardRatio = 1L, typeOfComputation = "direct", spendingTime = NA_real_) {
    .Call(`_lrstat_lrpower`, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, estimateHazardRatio, typeOfComputation, spendingTime)
}

#' @title Get group sequential design
#' @description Obtains the drift parameter and stopping boundaries for a
#' generic group sequential design assuming a constant treatment effect.
#'
#' @param beta Type II error. Defaults to 0.2.
#' @inheritParams param_kMax
#' @inheritParams param_informationRates
#' @inheritParams param_efficacyStopping
#' @inheritParams param_futilityStopping
#' @inheritParams param_criticalValues
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @inheritParams param_futilityBounds
#' @inheritParams param_typeBetaSpending
#' @inheritParams param_parameterBetaSpending
#' @inheritParams param_userBetaSpending
#' @param spendingTime A vector of length \code{kMax} for the error spending 
#'   time at each analysis. Defaults to missing, in which case, it is the 
#'   same as \code{informationRates}.
#'
#' @return A list of S3 class \code{design}.
#'
#' @examples
#'
#' getDesign(beta = 0.2,
#'           kMax = 2,
#'           informationRates = c(0.5,1),
#'           alpha = 0.025,
#'           typeAlphaSpending = "sfOF",
#'           typeBetaSpending = "sfP")
#'
#' @export
getDesign <- function(beta = 0.2, kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, userBetaSpending = NA_real_, spendingTime = NA_real_) {
    .Call(`_lrstat_getDesign`, beta, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, userBetaSpending, spendingTime)
}

#' @title Log-rank test sample size
#' @description Obtains the needed accrual duration given power and
#' follow-up time, the needed follow-up time given power and
#' accrual duration, or the needed absolute accrual rates given
#' power, accrual duration, follow-up duration, and relative accrual
#' rates in a two-group survival design.
#'
#' @param beta Type II error. Defaults to 0.2.
#' @inheritParams param_kMax
#' @inheritParams param_informationRates
#' @inheritParams param_efficacyStopping
#' @inheritParams param_futilityStopping
#' @inheritParams param_criticalValues
#' @inheritParams param_alpha
#' @inheritParams param_typeAlphaSpending
#' @inheritParams param_parameterAlphaSpending
#' @inheritParams param_userAlphaSpending
#' @inheritParams param_futilityBounds
#' @inheritParams param_typeBetaSpending
#' @inheritParams param_parameterBetaSpending
#' @inheritParams param_userBetaSpending
#' @inheritParams param_hazardRatioH0
#' @inheritParams param_allocationRatioPlanned
#' @inheritParams param_accrualTime
#' @inheritParams param_accrualIntensity
#' @inheritParams param_piecewiseSurvivalTime
#' @inheritParams param_stratumFraction
#' @inheritParams param_lambda1_stratified
#' @inheritParams param_lambda2_stratified
#' @inheritParams param_gamma1_stratified
#' @inheritParams param_gamma2_stratified
#' @inheritParams param_accrualDuration
#' @inheritParams param_followupTime
#' @inheritParams param_fixedFollowup
#' @inheritParams param_rho1
#' @inheritParams param_rho2
#' @inheritParams param_numSubintervals
#' @inheritParams param_estimateHazardRatio
#' @inheritParams param_typeOfComputation
#' @param interval The interval to search for the solution of
#' accrualDuration or followupDuration. Defaults to \code{c(0.001, 240)}.
#' Adjustment may be needed for non-monotone relationship with study power.
#' @param spendingTime A vector of length \code{kMax} for the error spending 
#'   time at each analysis. Defaults to missing, in which case, it is the 
#'   same as \code{informationRates}.
#'
#' @return A list of S3 class \code{lrpower}.
#'
#' @examples
#' # Piecewise accrual, piecewise exponential survivals, and 5% dropout by
#' # the end of 1 year.
#'
#' # Example 1: Obtains accrual duration given power and follow-up duration
#'
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              alpha = 0.025, typeAlphaSpending = "sfOF",
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = NA,
#'              followupTime = 18, fixedFollowup = FALSE)
#'
#'
#' # Example 2: Obtains follow-up duration given power and accrual duration
#'
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              alpha = 0.025, typeAlphaSpending = "sfOF",
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = 22,
#'              followupTime = NA, fixedFollowup = FALSE)
#'
#'
#' # Example 3: Obtains absolute accrual intensity given power,
#' # accrual duration, follow-up duration, and relative accrual intensity
#'
#' lrsamplesize(beta = 0.2, kMax = 2,
#'              informationRates = c(0.8, 1),
#'              alpha = 0.025, typeAlphaSpending = "sfOF",
#'              accrualTime = seq(0, 9),
#'              accrualIntensity = c(26/9*seq(1, 9), 26),
#'              piecewiseSurvivalTime = c(0, 6),
#'              stratumFraction = c(0.2, 0.8),
#'              lambda1 = c(0.0533, 0.0309, 1.5*0.0533, 1.5*0.0309),
#'              lambda2 = c(0.0533, 0.0533, 1.5*0.0533, 1.5*0.0533),
#'              gamma1 = -log(1-0.05)/12,
#'              gamma2 = -log(1-0.05)/12,
#'              accrualDuration = 22,
#'              followupTime = 18, fixedFollowup = FALSE)
#'              
#'
#' # Example 4: Non-inferiority trial with fixed follow-up and 
#' # superiority alternative
#' 
#' lrsamplesize(beta = 0.1, 
#'              kMax = 3, 
#'              alpha = 0.025,
#'              typeAlphaSpending = "sfOF",
#'              hazardRatioH0 = 1.1,
#'              accrualTime = c(0, 6),
#'              accrualIntensity = c(1000, 1500),
#'              lambda1 = log(2)/48*0.95,
#'              lambda2 = log(2)/48,
#'              gamma1 = -log(1-0.08)/12,
#'              gamma2 = -log(1-0.08)/12,
#'              accrualDuration = NA,
#'              followupTime = 18,
#'              fixedFollowup = 1, 
#'              typeOfComputation = "Schoenfeld")
#'                    
#' 
#'
#' @export
lrsamplesize <- function(beta = 0.2, kMax = NA_integer_, informationRates = NA_real_, efficacyStopping = NA_integer_, futilityStopping = NA_integer_, criticalValues = NA_real_, alpha = 0.025, typeAlphaSpending = "sfOF", parameterAlphaSpending = NA_real_, userAlphaSpending = NA_real_, futilityBounds = NA_real_, typeBetaSpending = "none", parameterBetaSpending = NA_real_, userBetaSpending = NA_real_, hazardRatioH0 = 1, allocationRatioPlanned = 1, accrualTime = 0L, accrualIntensity = 20L, piecewiseSurvivalTime = 0L, stratumFraction = 1L, lambda1 = 0.0309, lambda2 = 0.0533, gamma1 = 0L, gamma2 = 0L, accrualDuration = NA_real_, followupTime = 18, fixedFollowup = 0L, rho1 = 0, rho2 = 0, numSubintervals = 300L, estimateHazardRatio = 1L, typeOfComputation = "direct", interval = as.numeric( c(0.001, 240)), spendingTime = NA_real_) {
    .Call(`_lrstat_lrsamplesize`, beta, kMax, informationRates, efficacyStopping, futilityStopping, criticalValues, alpha, typeAlphaSpending, parameterAlphaSpending, userAlphaSpending, futilityBounds, typeBetaSpending, parameterBetaSpending, userBetaSpending, hazardRatioH0, allocationRatioPlanned, accrualTime, accrualIntensity, piecewiseSurvivalTime, stratumFraction, lambda1, lambda2, gamma1, gamma2, accrualDuration, followupTime, fixedFollowup, rho1, rho2, numSubintervals, estimateHazardRatio, typeOfComputation, interval, spendingTime)
}

set_seed <- function(seed) {
    invisible(.Call(`_lrstat_set_seed`, seed))
}

stl_sort <- function(x) {
    .Call(`_lrstat_stl_sort`, x)
}

#' @title Find interval numbers of indices
#' @description The implementation of \code{findInterval()} in R from Advanced
#' R by Hadley Wickham. Given a vector of non-decreasing breakpoints in v,
#' find the interval containing each element of x; i.e., if
#' \code{i <- findInterval2(x,v)}, for each index \code{j} in \code{x},
#' v[i[j]] <= x[j] < v[i[j] + 1]
#' where v[0] := -Inf, v[N+1] := +Inf, and \code{N = length(v)}.
#'
#' @param x The numeric vector of interest.
#' @param v The vector of break points.
#' @return A vector of \code{length(x)} with values in \code{0:N} where
#'   \code{N = length(v)}.
#'
#' @keywords internal
#'
#' @examples
#' x <- 2:18
#' v <- c(5, 10, 15) # create two bins [5,10) and [10,15)
#' cbind(x, findInterval2(x, v))
#'
#' @export
findInterval2 <- function(x, v) {
    .Call(`_lrstat_findInterval2`, x, v)
}

errorSpentcpp <- function(t, error, sf, sfpar) {
    .Call(`_lrstat_errorSpentcpp`, t, error, sf, sfpar)
}

exitprobcpp <- function(b, a, theta, I) {
    .Call(`_lrstat_exitprobcpp`, b, a, theta, I)
}

qtpwexpcpp <- function(probability, piecewiseSurvivalTime, lambda, lowerBound) {
    .Call(`_lrstat_qtpwexpcpp`, probability, piecewiseSurvivalTime, lambda, lowerBound)
}

