% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_data.R
\docType{data}
\name{sample_no_continuity}
\alias{sample_no_continuity}
\title{Sample Dataset Without Continuity Between Elections}
\format{
A data frame with 15 rows and 5 variables (same structure as \code{\link{sample_data}}).
}
\source{
Fictitious data
}
\usage{
sample_no_continuity
}
\description{
A variant of \code{\link{sample_data}} in which no candidate appears in more
than one election. This breaks the continuity between elections, making the
dataset useful for testing whether network-building functions correctly handle
cases with no longitudinal links across candidate lists.
}
\examples{
# Basic inspection
str(sample_no_continuity)

# Quick continuity diagram (basic and unformatted version)
\donttest{plot_continuity(sample_no_continuity)}
}
\keyword{datasets}
