% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/municipalities.R
\docType{data}
\name{Nebanice_CH_cz}
\alias{Nebanice_CH_cz}
\title{Municipal Election Data: Nebanice (CH, CZ)}
\format{
An object of class \code{data.frame} with 136 rows and 14 columns.
}
\source{
The dataset was compiled primarily from official election results published by
the Czech Statistical Office. Additional contextual or verification information
(such as post-election roles) was obtained from publicly available municipal
records.
\itemize{
\item \href{https://www.volby.cz/index_en.htm}{Czech Statistical Office}
\item \href{https://www.nebanice.cz/}{Municipality website}
}
}
\usage{
Nebanice_CH_cz
}
\description{
A dataset containing individual-level candidacy records from municipal
elections in the municipality of Nebanice (district Cheb, Czech Republic).
}
\details{
\tabular{ll}{
   \strong{Dataset overview:} \tab  \cr
   Municipality: \tab Nebanice \cr
   District: \tab Cheb \cr
   Country: \tab Czech Republic \cr
   Number of elections: \tab 9 \cr
   Elections covered: \tab 1994, 1998, 2002, 2006, 2010, 2014, 2018, 2019, 2022 \cr
   Number of candidacies (rows): \tab 136 \cr
   Note: \tab \href{https://www.nebanice.cz/}{Municipality website} \cr
}
}
\section{Description of variables}{
\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   elections \tab Election identifiers (numeric) \cr
   candidate \tab Candidate's full name (character) \cr
   list_name \tab Name of the candidate list (character) \cr
   list_pos \tab Candidate's position on the list (numeric) \cr
   pref_votes \tab Number of preferential votes (numeric) \cr
   elected \tab Logical; TRUE if candidate was elected \cr
   nom_party \tab Nominating party (character) \cr
   pol_affil \tab Political affiliation (character) \cr
   mayor \tab TRUE if elected mayor \cr
   dep_mayor \tab TRUE if elected deputy mayor \cr
   board \tab TRUE if member of the executive board \cr
   gov_support \tab TRUE if supported the local government \cr
   elig_voters \tab Number of eligible voters (numeric) \cr
   ballots_cast \tab Number of ballots cast (numeric) \cr
}


Each record describes one candidate's run for office, including their candidate
list affiliation, position on the list, nominating party, political affiliation,
number of preferential votes, and whether they were elected or held specific
positions (mayor, deputy mayor, member of the executive body).

The dataset also includes contextual election-level information, such as the
number of eligible voters and ballots cast, which can be used to calculate
voter turnout and related indicators. These variables appear only once per
election and constituency (they may be stored in a single candidate row for
that election/constituency)
}

\examples{
# Basic inspection
str(Nebanice_CH_cz)

# Example of a basic continuity diagram (unformatted version)
\donttest{plot_continuity(Nebanice_CH_cz, elections = "2010-")}
}
\references{
\itemize{
\item Hornek, J., & Juptner, P. (2020). Endangered Municipalities? Case Study of Three Small
and Critically Indebted Czech Municipalities.
\emph{NISPAcee Journal of Public Administration and Policy}, 13(1), 35-59.
[\href{https://reference-global.com/article/10.2478/nispa-2020-0002}{Full text}]
\item Hornek, J. (2016). \emph{Politicke dopady zadluzovani malych obci v Ceske republice}
(Political Impacts of Indebtedness of Small Municipalities in the Czech Republic).
Prague: Sociologicke nakladatelstvi (SLON).
[\href{https://karolinum.cz/en/books/hornek-politicke-dopady-zadluzovani-malych-obci-v-ceske-republice-24996}{Publisher link}]
\item Hornek, J. (2014). \emph{Politicke dopady zadluzovani malych obci v CR}
(Financing of Small Municipalities in the Czech Republic and its Political Impact).
Master thesis. Charles University.
[\href{https://dspace.cuni.cz/handle/20.500.11956/67813?locale-attribute=en}{Full text}]
}
}
\keyword{datasets}
