### R code from vignette source 'lorentz.Rnw'
### Encoding: UTF-8

###################################################
### code chunk number 1: lorentz.Rnw:88-89
###################################################
library(lorentz)


###################################################
### code chunk number 2: lorentz.Rnw:111-113
###################################################
u <- as.3vel(c(0.3,-0.4,0.8))
u


###################################################
### code chunk number 3: lorentz.Rnw:119-120
###################################################
as.4vel(u)


###################################################
### code chunk number 4: lorentz.Rnw:125-126
###################################################
boost(u)


###################################################
### code chunk number 5: lorentz.Rnw:131-132
###################################################
boost(u) %*% c(4,5,-2,3)


###################################################
### code chunk number 6: lorentz.Rnw:139-142
###################################################
v <- as.3vel(c(0.4,0.2,-0.1))
L <- boost(u) %*% boost(v)
L


###################################################
### code chunk number 7: lorentz.Rnw:151-153
###################################################
U <- orthog(L)
P <- pureboost(L)


###################################################
### code chunk number 8: lorentz.Rnw:159-161
###################################################
crossprod(U) - diag(4)
P - t(P)


###################################################
### code chunk number 9: kickoff
###################################################
library(lorentz)
u <- as.3vel(c(-0.7,+0.2,-0.3))
v <- as.3vel(c(+0.3,+0.3,+0.4))
w <- as.3vel(c(+0.1,+0.3,+0.8))
x <- as.3vel(c(-0.2,-0.1,-0.9))
u


###################################################
### code chunk number 10: try
###################################################
u+v
v+u


###################################################
### code chunk number 11: lorentz.Rnw:229-230
###################################################
(u+v)-gyr(u,v,v+u)


###################################################
### code chunk number 12: funcid
###################################################
f <- gyrfun(u,v)
(u+v)-f(v+u)    # should be zero


###################################################
### code chunk number 13: vec9
###################################################
u9 <- r3vel(9)
u9


###################################################
### code chunk number 14: vecfun
###################################################
f <- gyrfun(u9,v)
f(x)


###################################################
### code chunk number 15: u9+x
###################################################
u9+x


###################################################
### code chunk number 16: nonass
###################################################
(u+v)+w
u+(v+w)


###################################################
### code chunk number 17: nonass1
###################################################
(u+(v+w)) - ((u+v)+gyr(u,v,w))
((u+v)+w) - (u+(v+gyr(v,u,w)))


###################################################
### code chunk number 18: viss
###################################################
u <- as.3vel(c(0.4,0,0))
v <- seq(as.3vel(c(0.4,-0.2,0)), as.3vel(c(-0.3,0.9,0)),len=20)
w <- as.3vel(c(0.8,-0.4,0))


###################################################
### code chunk number 19: comfail1_fig
###################################################
comm_fail1(u=u, v=v)


###################################################
### code chunk number 20: comfail2_fig
###################################################
comm_fail2(u=u, v=v)


###################################################
### code chunk number 21: assfail_fig
###################################################
ass_fail(u=u, v=v, w=w, bold=10)


###################################################
### code chunk number 22: defuvw
###################################################
 u <- as.3vel(c(+0.5,0.1,-0.2))
 v <- as.3vel(c(+0.4,0.3,-0.2))
 w <- as.3vel(c(-0.3,0.2,+0.2))


###################################################
### code chunk number 23: lorentz.Rnw:364-367
###################################################
jj1 <- u %>% add(v)
jj2 <- u+v
speed(jj1-jj2)


###################################################
### code chunk number 24: lorentz.Rnw:372-375
###################################################
jj1 <- u %>% add(v) %>% add(w)
jj2 <- (u+v)+w
speed(jj1-jj2)


###################################################
### code chunk number 25: lorentz.Rnw:382-385
###################################################
jj1 <- u %>% add(v %>% add(w))
jj2 <- u+(v+w)
speed(jj1-jj2)


###################################################
### code chunk number 26: funcnot
###################################################
u <- as.3vel(c(0, 0.8, 0))
v <- r3vel(5,0.9)
x <- as.3vel(c(0.7, 0, -0.7))
y <- as.3vel(c(0.1, 0.3, -0.6))


###################################################
### code chunk number 27: lorentz.Rnw:406-408
###################################################
f <- gyrfun(u,v)
f(w)


###################################################
### code chunk number 28: lorentz.Rnw:414-415
###################################################
prod3(f(x),f(y)) - prod3(x,y)


###################################################
### code chunk number 29: lorentz.Rnw:420-423
###################################################
f <- gyrfun(u,v)
g <- gyrfun(v,u)
f(g(x)) - g(f(x))


###################################################
### code chunk number 30: lorentz.Rnw:429-431
###################################################
x %<>% f %>% add(y)      # x <- f(x)+y
x


###################################################
### code chunk number 31: lorentz.Rnw:443-445
###################################################
sol(299792458)
sol()


###################################################
### code chunk number 32: lorentz.Rnw:454-456
###################################################
u <- as.3vel(c(100,200,300))
u


###################################################
### code chunk number 33: lorentz.Rnw:463-464
###################################################
gam(u)


###################################################
### code chunk number 34: lorentz.Rnw:469-470
###################################################
gam(u)-1


###################################################
### code chunk number 35: lorentz.Rnw:476-477
###################################################
gamm1(u)


###################################################
### code chunk number 36: lorentz.Rnw:482-483
###################################################
boost(u)


###################################################
### code chunk number 37: lorentz.Rnw:489-492
###################################################
v <- as.3vel(c(400,-200,300))
boost(u) %*% boost(v)
boost(v) %*% boost(u)


