% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loopFuns.R
\name{df_qevd}
\alias{df_qevd}
\title{Return a data.frame of EVD Quantiles}
\usage{
df_qevd(x, p, evd_mod_str, interval = NULL, lower.tail = TRUE)
}
\arguments{
\item{x}{data.frame of EVD parameters, e.g. loc, scale, shape}

\item{p}{probability value.}

\item{evd_mod_str}{either a string "fgumbel", "fgev" or "fgumbelx" from the extreme value distribution (evd) in the evd package}

\item{interval}{A length two vector containing the end-points of the interval to be searched for the quantiles, passed to the uniroot function.}

\item{lower.tail}{Logical; if TRUE (default), probabilities are P (X <= x), otherwise P (X > x).}
}
\value{
gives the quantile function corresponding to p
}
\description{
Return a data.frame of EVD Quantiles
}
\examples{
df = data.frame(loc = 1,scale = 0.5)
qevd_vector(df,1-0.05,"fgumbel")
}
\seealso{
\code{\link[evd:gev]{evd::qgev()}}, \code{\link[evd:gumbelx]{evd::qgumbelx()}}
}
