% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loonGrob.R
\name{condGrob}
\alias{condGrob}
\title{Create a named grob or a template grob depending on a test}
\usage{
condGrob(test = TRUE, grobFun = grob, name = "grob name", ...)
}
\arguments{
\item{test}{Either `TRUE` or `FALSE` to indicate whether `grobFun` is to be used (default `TRUE`) or not.}

\item{grobFun}{The function to be used to create the grob when `test = TRUE` (e.g. `textGrob`, `polygonGrob`, etc.).}

\item{name}{The name to be used for the returned grob.}

\item{...}{The arguments to be given to the `grobFun` (or to `grob()` when `test = FALSE`).}
}
\value{
A grob as produced by either the `grobFun` given or by `grob()` using the remaining arguments.
If `test = FALSE` then the name is suffixed by ": `grobFun name` arguments".
}
\description{
Creates and returns a grid object using the function
given by `grobFun` when `test` is `TRUE`  Otherwise a simple `grob()`
is produced with the same parameters.  All grob parameters are given in `...`.
}
\examples{
myGrob <- condGrob(test = (runif(1) > 0.5),
                   grobFun = textGrob,
                   name = "my label",
                   label = "Some random text")
myGrob

}
