% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_getPlots.R
\name{l_getPlots.l_tour}
\alias{l_getPlots.l_tour}
\title{Query a loon widget}
\usage{
\method{l_getPlots}{l_tour}(target)
}
\arguments{
\item{target}{a \code{loon} object}
}
\value{
a \code{loon} widget
}
\description{
A generic function to query the \code{loon} (tcl) widget from the given target
}
\examples{
if(interactive()) {
  p <- l_tour(iris[, -5])
  l_isLoonWidget(p) # FALSE
  q <- l_getPlots(p)
  l_isLoonWidget(q) # TRUE

  # `l_compound` widget
  p <- l_tour_pairs(tourr::flea[, -7])
  l_isLoonWidget(p) # FALSE
  q <- l_getPlots(p)
  l_isLoonWidget(q) # FALSE
  is(q, "l_compound") # TRUE
}
}
