% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer_callback.R
\name{l_layer_callback}
\alias{l_layer_callback}
\title{Tour Layer Configuration}
\usage{
l_layer_callback(target, layer, ...)
}
\arguments{
\item{target}{either a `l_tour` object or a loon widget}

\item{layer}{the layer need to be modified}

\item{...}{some useful info for the layer configuration (i.e. tours, projections, etc)}
}
\value{
this callback function does not return any object. As the
slider bar is scrolled, for the specified layer, the callback function
will be fired and the layer will be configured.
}
\description{
Mainly used in the 2D (or 1D) tour interactive layer configuration
}
\details{
It is a \code{S3} method. The object class is determined by the layer **label**
}
\examples{
if(interactive() && requireNamespace("tourr")) {
  # 1D tour
  p <- l_tour(iris[, -5], tour = tourr::grand_tour(1L))
  # add layer density
  l <- l_layer(l_getPlots(p),
               stats::density(p['x']),
               label = "density")

  # as we scroll the bar, the density curve does not change
  # unless the following function is executed
  l_layer_callback.density <- function(target, layer, ...) {

      layer <- loon::l_create_handle(c(l_getPlots(target), layer))
      den <- stats::density(x)

      loon::l_configure(layer,
                        x = den$x,
                        y = den$y)

      invisible()
  }
}

}
