% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/psislw.R
\name{psislw}
\alias{psislw}
\title{Pareto smoothed importance sampling (PSIS)}
\usage{
psislw(lw, wcp = 0.2, wtrunc = 3/4, cores = parallel::detectCores())
}
\arguments{
\item{lw}{a matrix or vector of log weights. For computing LOO \code{lw =
-log_lik} (see \code{\link{extract_log_lik}}) and is an \eqn{S} by \eqn{N}
matrix where \eqn{S} is the number of simulations and \eqn{N} is the number
of data points. (If \code{lw} is a vector it will be coerced to a
one-column matrix.)}

\item{wcp}{the proportion of importance weights to use for the generalized
Pareto fit. The \code{100*wcp}\% largest weights are used as the sample
from which to estimate the parameters of the generalized Pareto
distribution.}

\item{wtrunc}{for truncating very large weights to \eqn{S}^\code{wtrunc}. Set
to zero for no truncation.}

\item{cores}{the number of cores to use for parallelization.}
}
\value{
A named with list with components \code{lw_smooth} (modified log
  weights) and \code{pareto_k} (estimated generalized Pareto shape parameters
  \eqn{k}).
}
\description{
Pareto smoothed importance sampling (PSIS)
}
\details{
See the 'PSIS-LOO' section in \code{\link{loo-package}}.
}
\note{
This function is primarily intended for internal use, but is exported
  so that users can call it directly for other purposes. Users simply
  wishing to compute LOO should use the \code{\link{loo}} function.
}
\seealso{
\code{\link{loo-package}}, \code{\link{loo}}
}

