% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{r_ltrc_elife}
\alias{r_ltrc_elife}
\title{Sample observations from a left-truncated right-censored excess lifetime distribution}
\usage{
r_ltrc_elife(
  n,
  scale,
  rate,
  shape,
  lower,
  upper,
  family = c("exp", "gp", "gomp", "gompmake", "weibull", "extgp", "gppiece",
    "extweibull", "perks", "beard", "perksmake", "beardmake")
)
}
\arguments{
\item{n}{sample size}

\item{scale}{scale parameter}

\item{shape}{shape parameter(s)}

\item{lower}{vector of lower bounds}

\item{upper}{vector of upper bounds above which data are right-truncated}

\item{family}{string; choice of parametric family, either exponential (\code{exp}), Weibull (\code{weibull}), generalized Pareto (\code{gp}), Gompertz (\code{gomp}) or extended generalized Pareto (\code{extgp}).}
}
\value{
a list with \code{n} observations \code{dat} and a logical vector of the same length with \code{TRUE} for right-censored observations and \code{FALSE} otherwise.
}
\description{
Sample observations from a left-truncated right-censored excess lifetime distribution
}
\examples{
n <- 100L
# the lower and upper bound are either scalar,
# or else vectors of length n
r_ltrc_elife(n = n, scale = 5, shape = -0.1,
               lower = pmax(0, runif(n, -0.5, 1)),
               upper = 5,
               family = "gp")
}
\keyword{internal}
