% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centroid.R
\name{lol.classify.nearestCentroid}
\alias{lol.classify.nearestCentroid}
\title{Nearest Centroid Classifier Training}
\usage{
lol.classify.nearestCentroid(X, Y, ...)
}
\arguments{
\item{X}{\code{[n, d]} the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{\code{[n]} the labels of the \code{n} samples.}

\item{...}{optional args.}
}
\value{
A list of class \code{nearestCentroid}, with the following attributes:
\item{centroids}{\code{[K, d]} the centroids of each class with \code{K}  classes in \code{d} dimensions.}
\item{ylabs}{\code{[K]} the ylabels for each of the \code{K} unique classes, ordered.}
\item{priors}{\code{[K]} the priors for each of the \code{K} classes.}
}
\description{
A function that trains a classifier based on the nearest centroid.
}
\section{Details}{

For more details see the help vignette:
\code{vignette("centroid", package = "lolR")}
}

\examples{
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
model <- lol.classify.nearestCentroid(X, Y)
}
\author{
Eric Bridgeford
}
