% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logic.boosting.R
\name{predict.linear.logic}
\alias{predict.linear.logic}
\title{Prediction for \code{linear.logic} models}
\usage{
\method{predict}{linear.logic}(object, X, Z = NULL, s = NULL, ...)
}
\arguments{
\item{object}{Fitted \code{linear.logic} model}

\item{X}{Matrix or data frame of binary input data.
This object should correspond to the binary matrix for fitting the model.}

\item{Z}{Optional quantitative covariables supplied as a matrix or
data frame. Only used (and required) if the model was fitted using them.}

\item{s}{Regularization parameter. Only used if \code{type = "lasso"} or
\code{type = "cv.lasso"} was set. Only useful if the penalty saved in
\code{object$s} should be overwritten.}

\item{...}{Ignored additional parameters}
}
\value{
A numeric vector of predictions. For binary outcomes,
  this is a vector with estimates for
  \eqn{P(Y=1 \mid X = x)}.
}
\description{
Use new input data and a fitted \code{linear.logic} model to
predict corresponding outcomes.
}
