% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{stop}
\alias{stop}
\title{Stop Function Log Handler}
\usage{
stop(..., call. = TRUE, domain = NULL, .loggit = TRUE, echo = TRUE)
}
\arguments{
\item{...}{zero or more objects which can be coerced to character
    (and which are pasted together with no separator) or a single
    condition object.}

\item{call.}{logical, indicating if the call should become part of the
    error message.}

\item{domain}{see \code{\link[base]{gettext}}.  If \code{NA}, messages will
    not be translated.}

\item{.loggit}{Should \code{loggit()} execute? Defaults to \code{TRUE}.}

\item{echo}{Should \code{loggit()}'s log entry be echoed to the console, as well? Defaults to \code{TRUE}.}
}
\value{
No return value.
}
\description{
This function is identical to base R's \code{\link[base:stop]{stop}},
but it includes logging of the exception message via \code{loggit()}.
}
\examples{
  if (2 < 1) stop("This is a completely false condition, which throws an error")

}
\seealso{
Other handlers: 
\code{\link{message}()},
\code{\link{stopifnot}()},
\code{\link{warning}()}
}
\concept{handlers}
