% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cca-r2.R
\name{lod_root2}
\alias{lod_root2}
\title{Single pollutant \code{sqrt(2)} imputation.}
\usage{
lod_root2(formula, df, lod, type)
}
\arguments{
\item{formula}{A R formula in the form \code{outcome ~ exposure + covariates}.}

\item{df}{A data.frame that contains the variables \code{formula}
references.}

\item{lod}{Name of the limit of detection variable.}

\item{type}{The type of regression to perform. Acceptable options are
linear and logistic.}
}
\description{
lod_root2 is a helper function that performs single imputation with
\code{lod / sqrt(2)}, a common ad hoc approach used in single-pollutant
modeling. The function can be  used to compare with clmi.
}
\note{
Depending on the transformation used, a "Complicated transformation" error
 may occur. For example, the transformation \code{a * exposure} will cause an
 error. In this case, define a transformation function as
 \code{f <- function(exposure) a * exposure} and use \code{f} in your
 formula. This technical limitation is unavoidable at the moment.
}
\examples{
# load lodi's toy data
library(lodi)
data("toy_data")
lodi.out <- lod_root2(case_cntrl ~ poll + smoking + gender, toy_data, lod,
                        logistic)
# see the fit model
lodi.out$model

# we can log transform poll to make it normally distributed
lodi.out <- lod_root2(case_cntrl ~ log(poll) + smoking + gender, toy_data,
                        lod, logistic)
lodi.out$model

# transforming the exposure results in a new column being added to data,
# representing the transformed lod.
head(lodi.out$data)

# You can even define your own transformation functions and use them
f <- function(x) exp(sqrt(x))
lodi.out <- lod_root2(case_cntrl ~ f(poll) + smoking + gender, toy_data, lod,
                        logistic)
head(lodi.out$data)
}
