% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_GenROT_bivariate.R
\name{h_GenROT_bivariate}
\alias{h_GenROT_bivariate}
\title{Rule-of-Thumb bandwidth selectors for bivariate covariate setting}
\usage{
h_GenROT_bivariate(Z1, Z2, Y, omega, kernel = gaussK)
}
\arguments{
\item{Z1}{The first covariate data values.}

\item{Z2}{The second covariate data values.}

\item{Y}{The response data values.}

\item{omega}{Numeric vector of level between 0 and 1 where 0.5 corresponds
to the mean.}

\item{kernel}{The kernel used to perform the estimation. In default setting,
\code{kernel=gaussK}. See details in \code{\link[locpol]{Kernels}}.}
}
\value{
\code{\link{h_GenROT_bivariate}} provides the general Rule-of-Thumb bandwidth selector
for the expectile regression, in the bivariate covariate setting,
proposed by Adam and Gijbels (2021b).
}
\description{
General Rule-of-Thumb bandwidth selector for the expectile regression
proposed by Adam and Gijbels (2021b) see Formula (26) for a bivariate covariate setting.
 The weight functions are chosen to be equal to the indicator
 functions on \eqn{[min(Z_{ki})+0.1,max(Z_{ki})-0.1]} for \code{k=1,2}
 (i.e. for the two covariates) and \code{j=0} and \code{p=1}.
}
\examples{
library(locpol)
library(lestat)
set.seed(6)
dist <- muniformdistribution(rep(0, 2), rep(1, 2))
values<-simulate(dist,200)
Z_1<-values[,1]
Z_2<-values[,2]
Z<-rbind(Z_1,Z_2)
gamma=cbind(3,-0.4)
set.seed(7)
eta_1<-rnorm(100,0,1)
X1=(gamma\%*\%Z)+(1.5*eta_1)
set.seed(8)
eta_2<-rnorm(100,0,2)
X2=(gamma\%*\%Z)+(1.5*eta_2)
X<-rbind(X1,X2)
set.seed(9)
epsilon<-rt(100,3)
delta_true<-rbind(0,-0.8)
Y=as.numeric((t(delta_true)\%*\%X)+(0.2*exp(1.5*(gamma\%*\%Z)))+epsilon)

h=h_GenROT_bivariate(Z1=Z_1,Z2=Z_2,Y=Y,kernel=gaussK,omega=0.1)
#h=0.1241427

}
\references{
{

Adam, C. and Gijbels, I. (2021b). Partially linear expectile regression using
local polynomial fitting. In Advances in Contemporary Statistics and Econometrics:
Festschrift in Honor of Christine Thomas-Agnan, Chapter 8, pages 139–160. Springer, New York.

}
}
