#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
/* do this first to get the right options for math.h */
#include <R_ext/Arith.h>
#include <R.h>
#include <Rmath.h>
#include <Rinternals.h>
#include <float.h>

void d2Dsigma(double *x1, double *x2, double *y1, double *y2, double *sigma, int *nx, int *ny, double *depth) {
  double m1, m2, dy1, dy2, dy3, a1, a2, a3, b1, b2, b3;
  double x11, x12, x13, x21, x22, x23;
  int ind1, ind2, i1, i2, i3; 
  ind1 = -1;
  for (i1 = 0 ; i1 < (*nx-2) ; i1++) {
    for (i2 = (i1+1) ; i2 < (*nx-1) ; i2++) {
      for (i3 = (i2+1); i3 < *nx ; i3++) {
        ind1 += 1;
        m1 = (x1[i1]+x1[i2]+x1[i3])/3.0;
        m2 = (x2[i1]+x2[i2]+x2[i3])/3.0;
        x11 = *sigma*(x1[i1]-m1)+m1;
        x12 = *sigma*(x1[i2]-m1)+m1;
        x13 = *sigma*(x1[i3]-m1)+m1;
        x21 = *sigma*(x2[i1]-m2)+m2;
        x22 = *sigma*(x2[i2]-m2)+m2;
        x23 = *sigma*(x2[i3]-m2)+m2;
        for (ind2 = 0 ; ind2 < *ny ; ind2++) {	  
          dy1 = sqrt(R_pow((x11-y1[ind2]), 2.0)+R_pow((x21-y2[ind2]), 2.0));
          dy2 = sqrt(R_pow((x12-y1[ind2]), 2.0)+R_pow((x22-y2[ind2]), 2.0));
          dy3 = sqrt(R_pow((x13-y1[ind2]), 2.0)+R_pow((x23-y2[ind2]), 2.0));

          if (dy1==0.0 | dy2==0.0 | dy3==0.0) {
            depth[ind2] += 1.0;
          } else {
            // printf("dy %6.3f %6.3f %6.3f \n", dy1, dy2, dy3);
	    a1 = atan2((x11-y1[ind2]), (x21-y2[ind2]));
	    a2 = atan2((x12-y1[ind2]), (x22-y2[ind2]));
	    a3 = atan2((x13-y1[ind2]), (x23-y2[ind2]));
          // printf("atan %6.3f %6.3f %6.3f \n", a1, a2, a3);
            if (a1 < 0.0)  a1 += 2.0*M_PI;
            if (a2 < 0.0)  a2 += 2.0*M_PI;
            if (a3 < 0.0)  a3 += 2.0*M_PI;
          // printf("a %6.3f %6.3f %6.3f \n", a1, a2, a3);
            if (a1 > a2 & a1 > a3) {
	      b3 = a1;
              if (a2 > a3) {
	        b1 = a3;
                b2 = a2;
              } else {
  	        b1 = a2;
                b2 = a3;             
              }
	    } else if (a2 > a3) {
              b3 = a2;
              if (a1 > a3) {
                b1 = a3;
                b2 = a1;
              } else {
                b1 = a1;
                b2 = a3;
              }
            } else {
              b3 = a3;
              if (a1 > a2) {
                b1 = a2;
                b2 = a1;
              } else {
                b1 = a1;
                b2 = a2;
              }
            }
          // printf("b %6.3f %6.3f %6.3f \n", b1, b2, b3);
            a1 = b3-b1;
            a2 = b1-b2;
            a3 = b2-b3;
            if (a1 < 0.0)  a1 += 2.0*M_PI;
            if (a2 < 0.0)  a2 += 2.0*M_PI;
            if (a3 < 0.0)  a3 += 2.0*M_PI;
          // printf('angle %6.3f %6.3f %6.3f \n', a1, a2, a3);
            if (a1 >= M_PI & a2 >= M_PI & a3 >= M_PI) {
            // printf("%6.3f %6.3f %6.3f \n", a1, a2, a3);
	      depth[ind2] += 1.0;
            }
          }
        }
      }
    }
  }
}
