% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locStra.r
\name{sMatrix}
\alias{sMatrix}
\title{C++ implementation to compute the s-matrix (the weighted Jaccard similarity matrix) for a (sparse) input matrix as in the 'Stego' package: https://github.com/dschlauch/stego}
\usage{
sMatrix(m, useCpp = TRUE, sparse = TRUE, Djac = FALSE, phased = FALSE)
}
\arguments{
\item{m}{A (sparse) matrix for which the s-matrix is sought. The input matrix is assumed to be oriented to contain the data for one individual per column.}

\item{useCpp}{Flag to switch between R or C++ implementations. Default is \code{useCpp=TRUE}.}

\item{sparse}{Flag to switch between purpose-built dense or sparse implementations. Default is \code{sparse=TRUE}.}

\item{Djac}{Flag to switch between the unweighted (\code{Djac=TRUE}) or weighted (\code{Djac=FALSE}) version. Default is \code{Djac=FALSE}.}

\item{phased}{Boolean flag to indicate if the input matrix is phased. Default is \code{phased=FALSE}.}
}
\value{
The s-matrix (the weighted Jaccard matrix) of \code{m}.
}
\description{
C++ implementation to compute the s-matrix (the weighted Jaccard similarity matrix) for a (sparse) input matrix as in the 'Stego' package: https://github.com/dschlauch/stego
}
\examples{
require(locStra)
require(Matrix)
m <- matrix(sample(0:1,15,replace=TRUE),ncol=3)
sparseM <- Matrix(m,sparse=TRUE)
print(sMatrix(sparseM))

}
\references{
Daniel Schlauch (2016). Implementation of the stego algorithm - Similarity Test for Estimating Genetic Outliers. https://github.com/dschlauch/stego
}
